/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.Descriptor;


/**
 * All classes responsible for performing compliance tests on an J2EE architecture
 * like web applications or connectors implement this interface to be called by
 * the verifier harness. Classes with such a responsibility are called managers
 * in the verifier harness.
 *
 * @author Jerome Dochez
 */
public interface JarCheck {

    /**
     * <p/>
     * Entry point to perform all tests pertinent to this implemented
     * architecture on a J2EE archive file (ear, war, rar...)
     * </p>
     *
     * @param descriptor descriptor instance for the J2EE
     *                   archive to test
     */
    void check(Descriptor descriptor) throws Exception;
    
}
