/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.annotation.AnnotationInfo;
import com.sun.enterprise.deployment.annotation.impl.DefaultErrorHandler;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.logging.LogDomains;
import com.sun.enterprise.util.LocalStringManagerImpl;

import java.util.logging.Logger;
import java.util.logging.LogRecord;
import java.util.logging.Level;

/**
 * This error handler class is used by the deployment code while building
 * descriptors. All annotation processor exceptions are eaten by this class so
 * that verifier can continue execution and report other failures.
 * 
 * @author Vikas Awasthi
 */
public class VerifierErrorHandler extends DefaultErrorHandler {

    private Logger logger = LogDomains.getLogger(LogDomains.AVK_VERIFIER_LOGGER);
    private ResultManager resultManager = null;

    public VerifierErrorHandler(ResultManager resultManager) {
        this.resultManager = resultManager;
    }

    public void error(AnnotationProcessorException ape)
            throws AnnotationProcessorException {
        logger.fine("Error : " + ape); // NOI18N
        AnnotationInfo info = ape.getLocator();
        String msg = (info==null) ? 
            ape.getMessage() :
            StringManagerHelper.getLocalStringsManager().getLocalString(
                "com.sun.enterprise.tools.verifier.annotation.error", // NOI18N
                "{3}\n annotation: {0}\n symbol: {1}\n location: {2}\n", // NOI18N
                new Object[] {info.getAnnotation(), info.getElementType(), 
                    info.getAnnotatedElement(), ape.getMessage()});
        LogRecord logRecord = new LogRecord(Level.SEVERE, msg);
        resultManager.log(logRecord);
    }
}
