/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.deployment.util.ModuleDescriptor;

/**
 * This class constructs the name of the app client/bean/connector as
 * appName.jarName.componentName
 *
 * @author Sheetal Vartak
 */

public class ComponentNameConstructor {

    private String appName = "";
    private String jarName = "";
    private String componentName = "";
    
    public ComponentNameConstructor(EjbDescriptor ejbDsc) {
	    EjbBundleDescriptor ejbBundle = ejbDsc.getEjbBundleDescriptor();
        ModuleDescriptor moduleDesc = ejbBundle.getModuleDescriptor();
        if(!moduleDesc.isStandalone()){ // print app name only for embedded ones
            this.appName = ejbBundle.getApplication().getRegistrationName();
        }
	    this.jarName = moduleDesc.getArchiveUri();
	    this.componentName = ejbDsc.getName();
    }

    // this takes care of all bundle descriptors.
    public ComponentNameConstructor(BundleDescriptor bundleDesc) {
        ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
        if(!moduleDesc.isStandalone()){ // print app name only for embedded ones
            this.appName = bundleDesc.getApplication().getRegistrationName();
        }
	    this.jarName = moduleDesc.getArchiveUri();
        // there is no point in printing comp name since it is bundle desc.
    }

    public ComponentNameConstructor(String appName, String jarName, String componentName) {
        this.appName = appName;
        this.jarName = jarName;
        this.componentName = componentName;
    }

    public ComponentNameConstructor(WebServiceEndpoint wse) {
        BundleDescriptor bundleDesc = wse.getBundleDescriptor();
        ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
        if(!moduleDesc.isStandalone()){ // print app name only for embedded ones
            this.appName = bundleDesc.getApplication().getRegistrationName();
        }
        this.jarName = moduleDesc.getArchiveUri();
        // WebServiceEndpoint path is WebServices->WebService->WebServiceEndpoint
        this.componentName = wse.getWebService().getName()+"#"+wse.getEndpointName(); // NOI18N
    }

    public ComponentNameConstructor(ServiceReferenceDescriptor srd) {
        BundleDescriptor bundleDesc = srd.getBundleDescriptor();
        ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
        if(!moduleDesc.isStandalone()){ // print app name only for embedded ones
            this.appName = bundleDesc.getApplication().getRegistrationName();
        }
        this.jarName = moduleDesc.getArchiveUri();
        this.componentName = srd.getName();
    }

    public ComponentNameConstructor(WebService wsDsc) {
        BundleDescriptor bundleDesc = wsDsc.getBundleDescriptor();
        ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
        if(!moduleDesc.isStandalone()){ // print app name only for embedded ones
            this.appName = bundleDesc.getApplication().getRegistrationName();
        }
        this.jarName = moduleDesc.getArchiveUri();
        this.componentName = wsDsc.getName();
    }

    public ComponentNameConstructor(Application application) {
        this.appName = application.getRegistrationName();
    }

    public ComponentNameConstructor(PersistenceUnitDescriptor
            descriptor) {
        PersistenceUnitsDescriptor persistenceUnitsDescriptor =
                descriptor.getParent();
        RootDeploymentDescriptor container = persistenceUnitsDescriptor.getParent();
        if(container.isApplication()) {
            this.appName = Application.class.cast(container).getRegistrationName();
            this.componentName = persistenceUnitsDescriptor.getPuRoot() +
                    "#"+descriptor.getName(); // NOI18N
        } else { // this PU is bundled inside a module
            BundleDescriptor bundleDesc = BundleDescriptor.class.cast(container);
            ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
            if(!moduleDesc.isStandalone()){ // print app name only for embedded ones
                this.appName = bundleDesc.getApplication().getRegistrationName();
            }
            this.jarName = moduleDesc.getArchiveUri();
            String puRoot = persistenceUnitsDescriptor.getPuRoot();
            // for EJB module, PURoot is empty, so to avoid ## in report, this check is needed.
            this.componentName = ("".equals(puRoot) ? "" : puRoot + "#") + descriptor.getName(); // NOI18N
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if(!isNullOrEmpty(appName)){
            sb.append(appName);
        }
        if(!isNullOrEmpty(jarName)){
            if(!isNullOrEmpty(appName)) sb.append("#"); // NOI18N
            sb.append(jarName);
        }
        if(!isNullOrEmpty(componentName)){
            if(!isNullOrEmpty(jarName) || !isNullOrEmpty(appName)) sb.append("#"); // NOI18N
            sb.append(componentName);
        }
        return sb.toString();
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

}
