/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * ConnectionRequestInfoImplHashcode.java
 *
 * Created on September 27, 2000, 11:08 AM
 */

package com.sun.enterprise.tools.verifier.tests.connector;

import java.io.File;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.tests.*;

/**
 * Test wether the implementatin of the ConnectionRequestInfo interface
 * properly overrides the hashcode method
 *
 * @author  Jerome Dochez
 * @version 
 */

public class ConnectionRequestInfoImplHashcode extends ConnectorTest implements ConnectorCheck {


    /** <p>
     * Test wether the implementatin of the ConnectionRequestInfo interface
     * properly overrides the hashcode method.
     * </p>
     *
     * @paramm descriptor deployment descriptor for the rar file
     * @return result object containing the result of the individual test
     * performed
     */
    public Result check(ConnectorDescriptor descriptor) {
        Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        
//        File f=Verifier.getArchiveFile(descriptor.getModuleDescriptor().getArchiveUri());     
        Class c = findImplementorOf(descriptor, "javax.resource.spi.ConnectionRequestInfo");
        if (c == null) {
            result.addNaDetails(smh.getLocalString
				  ("tests.componentNameConstructor",
				   "For [ {0} ]",
				   new Object[] {compName.toString()}));	
            result.notApplicable(smh.getLocalString
	    ("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.optionalInterfaceMissing", 
            "Warning: There is no implementation of the optional [ {0} ] interface",
            new Object[] {"javax.resource.spi.ConnectionRequestInfo"}));  
        } else {
            // An implementation of the interface is provided, let's check the equals method
            checkMethodImpl(c, "hashCode", null, "public int hashCode()", result);                    
        }
        return result;
    }        
}
