/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.ejb.*;
import com.sun.enterprise.tools.verifier.tests.*;
import java.util.*;

/**  
 * Enterprise Bean's business(...) methods name test.
 * Each enterprise Bean class must define zero or more business(...) methods. 
 * The method signatures must follow these rules: 
 * 
 * The methods in the remote/local interface should be present in the deployment 
 * descriptor
 *
 */
public class BusinessMethodMatchesWithDD extends EjbTest implements EjbCheck { 

    Result result = null;
    ComponentNameConstructor compName = null;

    /** 
     * Enterprise Bean's business(...) methods name test.
     * Each enterprise Bean class must define zero or more business(...) methods. 
     * The method signatures must follow these rules: 
     * 
     * The methods in the remote/local interface should be present in the 
     * deployment descriptor
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	result = getInitializedResult();
	compName = getVerifierContext().getComponentNameConstructor();

	if ((descriptor instanceof EjbSessionDescriptor)  ||
	    (descriptor instanceof EjbEntityDescriptor)) {
         
        if(descriptor.getRemoteClassName() != null && 
                !"".equals(descriptor.getRemoteClassName())) 
            commonToBothInterfaces(descriptor.getRemoteClassName(),
                                   descriptor, 
                                   MethodDescriptor.EJB_REMOTE);
        
        if(descriptor.getLocalClassName() != null && 
                !"".equals(descriptor.getLocalClassName())) 
            commonToBothInterfaces(descriptor.getLocalClassName(),
                                   descriptor, 
                                   MethodDescriptor.EJB_LOCAL);
	}
        
    if(result.getStatus() != Result.FAILED) {
        addGoodDetails(result, compName);
        result.passed(smh.getLocalString
                        (getClass().getName() + ".passed",
                        "Business method(s) are valid."));
    }
    return result;
    }
    
    /** 
     * This method is responsible for the logic of the test. It is called for 
     * both local and remote interfaces.
     * @param intf for the Remote/Local interface of the Ejb. 
     * @param descriptor the Enterprise Java Bean deployment descriptor
     * This parameter may be optional depending on the test 
     * @param methodIntf for the interface type
     */

    private void commonToBothInterfaces(String intf, 
                                        EjbDescriptor descriptor, 
                                        String methodIntf) {
        try {
            Class intfClass = Class.forName(intf, false, getVerifierContext().getClassLoader());
            
            boolean found = false;
            Set allMethods = new HashSet();
            
            for (Iterator e = 
                    descriptor.getPermissionedMethodsByPermission().values().iterator();e.hasNext();) {
                Set methodDescriptors = (Set) e.next();
                if (methodDescriptors != null)
                    allMethods.addAll(methodDescriptors);
            }
            for (Enumeration e = 
                    descriptor.getMethodContainerTransactions().keys();e.hasMoreElements();) {
                allMethods.add(e.nextElement());
            }
            
            for (Method remoteMethod : intfClass.getMethods()) {
                found = false;
                
                // we don't test the EJB methods
                if (remoteMethod.getDeclaringClass().getName().equals("javax.ejb.EJBObject")) 
                    continue;
                if (!remoteMethod.getName().startsWith("ejb") &&
                        !remoteMethod.getName().equals("class$") &&
                        !remoteMethod.getName().equals("setSessionContext")) {
                    
                    Iterator methods = allMethods.iterator();
                    while (methods.hasNext()) {
                        MethodDescriptor methodDescriptor = (MethodDescriptor)methods.next();
                        
                        if (methodDescriptor.getName().equals(remoteMethod.getName())) {
                            if (MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), 
                                    (new MethodDescriptor(remoteMethod,methodIntf)).getParameterClassNames())) {
                                found = true;
                                break;
                            }
                        }
                    }
                }
                if (!found) {
                    addErrorDetails(result, compName);
                    result.failed(smh.getLocalString
                                    (getClass().getName() + ".failed",
                                    "Error: Business method [ {0} ] is not defined " +
                                    "in the deployment descriptor.",
                                    new Object[] {remoteMethod.getName()}));
                } 
            }
            
        } catch (Exception e) {
            Verifier.debug(e);
            addErrorDetails(result, compName);
            result.failed(smh.getLocalString
                            (getClass().getName() + ".failedException",
                            "Error: Component interface [ {0} ] does not exist " +
                            "or is not loadable within bean [ {1} ].",
                            new Object[] {intf,descriptor.getName()}));
        }  
    }
}
