/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.deployment.EjbDescriptor;

import java.util.Set;

/**
 * A business interface must not extend javax.ejb.EJBObject or 
 * javax.ejb.EJBLocalObject.
 * 
 * @author Vikas Awasthi
 */
public class BusinessIntfInheritance extends EjbTest {
    
    public Result check(EjbDescriptor descriptor) {
        Result result = getInitializedResult();
        ComponentNameConstructor compName = 
                getVerifierContext().getComponentNameConstructor();

        Set<String> remoteAndLocalIntfs = descriptor.getRemoteBusinessClassNames();
        remoteAndLocalIntfs.addAll(descriptor.getLocalBusinessClassNames());
        
        for (String remoteOrLocalIntf : remoteAndLocalIntfs) {
            try {
                Class c = Class.forName(remoteOrLocalIntf, 
                                        false, 
                                        getVerifierContext().getClassLoader());
                if(javax.ejb.EJBObject.class.isAssignableFrom(c) ||
                        javax.ejb.EJBLocalObject.class.isAssignableFrom(c)) {
                    addErrorDetails(result, compName);
                    result.failed(smh.getLocalString
                                    (getClass().getName() + ".failed",
                                    "[ {0} ] extends either javax.ejb.EJBObject " +
                                    "or javax.ejb.EJBLocalObject.",
                                    new Object[] {remoteOrLocalIntf}));
                }
            } catch (ClassNotFoundException e) {
                Verifier.debug(e);
                addErrorDetails(result, compName);
                result.failed(smh.getLocalString
                                (getClass().getName() + ".failed1",
                                "Business Interface class [ {0} ] not found.",
                                new Object[] {remoteOrLocalIntf}));
            }
        }
        if(result.getStatus()!=Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                            (getClass().getName() + ".passed",
                            "Business Interface(s) are valid."));
        }
        
        return result;
    }
}
