/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;

import java.util.Set;
import java.lang.reflect.Method;

/**
 * Lifecycle callback interceptor methods defined on an interceptor class have 
 * the following signature: 
 * void <METHOD> (InvocationContext)
 *  
 * Lifecycle callback interceptor methods defined on a bean class have the 
 * following signature: 
 * void <METHOD>()
 * 
 * @author Vikas Awasthi
 */
public class CallbackMethodArgument extends InterceptorMethodTest {

    void testInterceptorMethods(Set<LifecycleCallbackDescriptor> callbackDescs,
                                String callbackMethodName,
                                Boolean isBeanMethod) {
        if(callbackMethodName.equals("AroundInvoke"))
            return; // this test applies only to lifecycle callback methods

        ClassLoader cl = getVerifierContext().getClassLoader();
        for (LifecycleCallbackDescriptor callbackDesc : callbackDescs) {
            try {
                Method method = callbackDesc.getLifecycleCallbackMethodObject(cl);
                Class<?>[] args = method.getParameterTypes();
                if(isBeanMethod && args.length!=0) {
                    logFailure(callbackMethodName, method);
                } else if(!isBeanMethod && 
                        (args.length!=1 || 
                                !javax.interceptor.InvocationContext.class.isAssignableFrom(args[0]))) {
                    logFailure(callbackMethodName, method);
                }
            } catch (Exception e) {}//ignore as it will be caught in other tests
        }
    }
}
