/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.*;

/**
 * Container managed relationship type field must use of the collection 
 * interface for on-to-many or many-to-many relationships and specify it in 
 * the Deployment Descriptor
 *
 * @author  Jerome Dochez
 * @version 
 */
public class CmrUseCorrectCollectionInterface extends CmrFieldTest {

    /**
     * run an individual verifier test of a declated cmr field of the class
     *
     * @param entity the descriptor for the entity bean containing the cmp-field    
     * @param info the descriptor for the declared cmr field
     * @param c the class owning the cmp field
     * @parma r the result object to use to put the test results in
     * 
     * @return true if the test passed
     */            
    protected boolean runIndividualCmrTest(Descriptor descriptor, RelationRoleDescriptor rrd, Class c, Result result) {
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        if (rrd.getPartner().getIsMany()) {
            // must be one the collection interface 
            if (rrd.getCMRFieldType()==null) {
                addErrorDetails(result, compName);
              result.addErrorDetails(smh.getLocalString
		    (getClass().getName() + ".failed2",
                    "Error : CMR field [ {0} ]  cmr-field-type must be defined for one-to-many or many-to-many relationships and the value of the cmr-field-type element must be either: java.util.Collection or java.util.Set",
	            new Object[] {rrd.getCMRField()}));                
                return false;
            } else {
                CMRFieldInfo info = rrd.getCMRFieldInfo();
                if (rrd.getCMRFieldType().equals(info.type.getName())) {
                    result.addGoodDetails(smh.getLocalString
    		    (getClass().getName() + ".passed",
                        "CMR field [ {0} ] is the same type as declared in the deployment descriptors [ {1} ]",
        	            new Object[] {info.name, info.role.getCMRFieldType()}));                
                    return true;                
                } else {
                    addErrorDetails(result, compName);
                    result.addErrorDetails(smh.getLocalString
    		    (getClass().getName() + ".failed",
                        "Error : CMR field [ {0} ] is not the same type as declared in the deployment descriptors [ {1} ]",
    	            new Object[] {info.name, info.role.getCMRFieldType()}));                
                    return false;
                }            
            }
        }
       return true;        
    }
}
