package com.sun.enterprise.tools.verifier.tests.ejb.runtime;

/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;

import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;


/** ejb [0,n]
 *    jms-durable-subscription-name ? [String]
 *
 * The jms-durable-subscription-name is the name of a durable subscription associated
 * with a message-driven bean.
 * The name should not be a null string.
 * The value is required if destination-type is Topic
 * and subscription-durability is durable
 * @author Irfan Ahmed
 */
public class ASEjbJMSDurableSubscriptionName extends EjbTest implements EjbCheck { 

    public Result check(EjbDescriptor descriptor) 
    {
	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        boolean oneFailed = false;
        try{
            EjbMessageBeanDescriptor msgBeanDesc = (EjbMessageBeanDescriptor)descriptor;
            String jmsDurableName = msgBeanDesc.getDurableSubscriptionName();
            if(jmsDurableName != null){
                if(jmsDurableName.length()==0)
                {
                    addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(getClass().getName()+".failed",
                        "FAILED [AS-EJB ejb] : jms-durable-subscription-name cannot be an empty string value"));
                }else{
                    addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(getClass().getName()+".passed",
                        "PASSED [AS-EJB ejb] : jms-durable-subscription-name is {0}", new Object[]{jmsDurableName}));
                }
            }else{
                if(descriptor instanceof EjbMessageBeanDescriptor){
                    if(msgBeanDesc.hasTopicDest() && msgBeanDesc.hasDurableSubscription()){
                        boolean failed = false;
                        int count = getCountNodeSet("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\""+descriptor.getName()+"\"]/mdb-resource-adapter");
                        if (count > 0) {
                            String value = getXPathValue("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\""+descriptor.getName()+"\"]/mdb-resource-adapter/resource-adapter-mid");
                            if(value==null || value.length()==0){
                                failed = true;
                            }
                        } 
                        else {
                            failed = true;
                        }
                        if (failed) {
                            addErrorDetails(result, compName);
                            result.failed(smh.getLocalString(getClass().getName()+".failed1",
                                "FAILED [AS-EJB ejb] : jms-durable-subscription-name should be defined for an MDB with"+
                                " destination type Topic and Durable subscription type"));
                        }
                    }else{
                        addNaDetails(result, compName);
                        result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable",
                            "NOT APPLICABLE [AS-EJB ejb] : jms-durable-subscription-name element is not defined"));
                    }
                }else{
                    addNaDetails(result, compName);
                    result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable",
                        "NOT APPLICABLE [AS-EJB ejb] : jms-durable-subscription-name element is not defined"));
                }
            }
        }catch(Exception ex){
            addErrorDetails(result, compName);
            result.addErrorDetails(smh.getLocalString
                (getClass().getName() + ".notRun",
                "NOT RUN [AS-EJB] : Could not create a descriptor object"));
        }
        return result;
    }
}
