/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import java.util.*;
import com.sun.enterprise.tools.verifier.tests.*;
import java.lang.reflect.*;

/* 
 *   @class.setup_props: ; 
 */ 

/*  
 *   @testName: check  
 *   @assertion_ids:  JSR109_WS_43; 
 *   @test_Strategy: 
 *   @class.testArgs: Additional arguments (if any) to be passed when execing the client  
 *   @testDescription: A servlet must only be linked to by a single port-component. 
 */

public class ServletLinkedToOnePortCompCheck  extends WSTest implements WSCheck {

    /**
     * @param descriptor the WebServices  descriptor
     * @return <code>Result</code> the results for this assertion
     */
    public Result check (WebServiceEndpoint descriptor) {

	Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        if (descriptor.implementedByEjbComponent()) {
           result.addNaDetails(smh.getLocalString
                     ("tests.componentNameConstructor", "For [ {0} ]",
                      new Object[] {compName.toString()}));
           result.notApplicable(smh.getLocalString
                 (getClass().getName() + ".notapp",
                 "This is an EJB Service Endpoint"));
           return result;
        }

    
        if (isLinkedToSinglePortComp(getAllEndPointsInApp(descriptor),descriptor.getLinkName())) {
           // result.pass
           result.addGoodDetails(smh.getLocalString
                                  ("tests.componentNameConstructor",
                                   "For [ {0} ]",
                                   new Object[] {compName.toString()}));
           result.passed(smh.getLocalString
                   (getClass().getName() + ".passed",
           "The Servlet associated with this end-point is linked to by a single port-component."));

        }
        else {
          // result.fail
          result.addErrorDetails(smh.getLocalString
                                  ("tests.componentNameConstructor",
                                   "For [ {0} ]",
                                   new Object[] {compName.toString()}));
          result.failed(smh.getLocalString
                (getClass().getName() + ".failed",
                "The Servlet associated with this end-point is linked to by multiple port-components."));

        }

        return result;
    }

    Collection getAllEndPointsInApp(WebServiceEndpoint desc) {
       Collection allWebServices = desc.getWebService().getWebServicesDescriptor().getWebServices();
       Collection ret = new Vector();
       for (Iterator it = allWebServices.iterator(); it.hasNext();) {
           ret.addAll(((WebService)it.next()).getEndpoints());
       }

     return ret;
    }

    // the compLink here is either an ejb-link or a servlet-link
    boolean isLinkedToSinglePortComp(Collection endPoints, String compLink) {
       boolean single = true;
       boolean linkAlreadySeen = false;
       for (Iterator it = endPoints.iterator(); it.hasNext();) {
           String myCompLink = ((WebServiceEndpoint)it.next()).getLinkName();

           if (myCompLink.equals(compLink)) {
              if (!linkAlreadySeen) {
                 linkAlreadySeen = true;
              }
              else {
                 single = false;
                 break;
              }
           }
       }
     return single;
    }
 }

