/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.wsclients;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import java.util.*;
import com.sun.enterprise.tools.verifier.tests.*;
import java.lang.reflect.*;

/* 
 *   @class.setup_props: ; 
 */ 

/*  
 *   @testName: check  
 *   @assertion_ids: JSR109_WS_52; 
 *   @test_Strategy: 
 *   @class.testArgs: Additional arguments (if any) to be passed when execing the client  
 *   @testDescription: handler-class Defines a fully qualified class name for the handler 
 *   implementation.
 */

// Make sure we are able to load the Handler classes
public class HandlerClassCheck extends WSClientTest implements WSClientCheck {

    /**
     * @param descriptor the WebServices  descriptor
     * @return <code>Result</code> the results for this assertion
     */
    public Result check (ServiceReferenceDescriptor descriptor) {

	Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        ClassLoader loader = getVerifierContext().getClassLoader();

        if (descriptor.hasHandlers()) {
           List handlerChain = descriptor.getHandlerChain();
           for (Iterator it = handlerChain.iterator(); it.hasNext();) {
                String hClass = ((WebServiceHandler)it.next()).getHandlerClass();
                Class cl = null;
                try {
                  cl = Class.forName(hClass, false, getVerifierContext().getClassLoader());
                  if ((cl != null) && ((javax.xml.rpc.handler.Handler.class).isAssignableFrom(cl))) {
                    //result.pass
                    result.addGoodDetails(smh.getLocalString
                                  ("tests.componentNameConstructor",
                                   "For [ {0} ]",
                                   new Object[] {compName.toString()}));
                    result.passed(smh.getLocalString (getClass().getName() + ".passed",
             "The Handler Class [{0}] exists and implements the javax.xml.rpc.handler.Handler Interface.",
                     new Object[] {hClass}));

                  }
                  else {
                     result.addErrorDetails(smh.getLocalString ("tests.componentNameConstructor",
                         "For [ {0} ]", new Object[] {compName.toString()}));
                        result.failed(smh.getLocalString (getClass().getName() + ".failed",
                        "Handler Class [{0}] does not implement javax.xml.rpc.handler.Handler",
                        new Object[] {hClass}));
                    
                  }
                }
                catch (ClassNotFoundException e) {
                    // result.fail, handler class not found
                     result.addErrorDetails(smh.getLocalString ("tests.componentNameConstructor",
                 "For [ {0} ]", new Object[] {compName.toString()}));
                 result.failed(smh.getLocalString (
                 "com.sun.enterprise.tools.verifier.tests.webservices.clfailed",
                 "The [{0}] Class [{1}] could not be Loaded",
                  new Object[] {"Handler Class", hClass}));

                }
           }
        }
        else {
         // result.NotApplicable
          result.addNaDetails(smh.getLocalString
                     ("tests.componentNameConstructor", "For [ {0} ]",
                      new Object[] {compName.toString()}));
          result.notApplicable(smh.getLocalString
                ( getClass().getName() + ".notapp",
                 "Not Applicable since No handlers defined in this WebService"));
        }

        return result;
    }
 }

