/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer;


/**
 * Thrown to indicate that the class-file enhancer failed to perform an
 * operation due to an error.  The enhancer is guaranteed to remain in a
 * consistent state.
 */
public class EnhancerUserException
    extends Exception
{
    /**
     * An optional nested exception.
     */
    public final Throwable nested;

    /**
     * Constructs an <code>EnhancerUserException</code> with no detail message.
     */
    public EnhancerUserException()
    {
        this.nested = null;
    }

    /**
     * Constructs an <code>EnhancerUserException</code> with the specified
     * detail message.
     */
    public EnhancerUserException(String msg)
    {
        super(msg);
        this.nested = null;
    }

    /**
     * Constructs an <code>EnhancerUserException</code> with an optional
     * nested exception.
     */
    public EnhancerUserException(Throwable nested)
    {
        super(nested.toString());
        this.nested = nested;
    }

    /**
     * Constructs an <code>EnhancerUserException</code> with the specified
     * detail message and an optional nested exception.
     */
    public EnhancerUserException(String msg, Throwable nested)
    {
        super(msg);
        this.nested = nested;
    }
}
