/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * HexConverter.java
 *
 * Create on March 3, 2000
 */

package com.sun.jdo.spi.persistence.support.sqlstore.utility;
 

public class HexConverter
{
	//
	// This method is directly modeled on qqsp_Stream::dumpBytes
	// and is used for similar purposes (e.g., CM Packet dumping)
	//
	private static final int AFTER_POS = 13; // one byte after position
	private static final int HEX_START = AFTER_POS + 2;
	private static final int WORDS_PER_LINE = 4;
	private static final int CHARS_PER_WORD = 10;
	private static final int CHAR_START = 56; // after 4 words of data

	/**
	 * The simple version doesn't have a lot of formatting
	 */
	public static String simpleFormatHexBytes (byte rawBytes[], int length)
	{
		int				i;
		String			result = new String();
		long			data;

		for (i = 0; i < length; i++)
		{
			data = (int)rawBytes[i] & 0xff;

			if (i > 0)
				result = result.concat(" "); // NOI18N

			if (Long.toHexString(data).length() == 1)
				result = result.concat("0"); // NOI18N
			result = result.concat(Long.toHexString(data));
		}

		result = result.concat("\n"); // NOI18N
		return result;
	}
		
			

	public static String formatHexBytes(byte rawBytes[], int length)
	{
		int             i, j, bufPtr;
		char			[]buf = new char[100];
		int             word = 0;
		long	        data;
		int             startPos = 0;
		String			dataAsHex;
		String			resultString = new String();

		//  Clear out the buffer
		for (j = 0; j < 100; j++)
			buf[j] = ' ';

		for (i = 0; i < length; i += 4)
		{
			//  Print 4 bytes of data at a time.
			bufPtr = (word * CHARS_PER_WORD) + HEX_START;

			dataAsHex = new String();
			for (j = 0; j < 4; j++)
			{
				try
				{
					data = (int)rawBytes[i + j] & 0xff;
				}
				catch (ArrayIndexOutOfBoundsException e)
				{
					data = 0;
				}
				if (Long.toHexString(data).length() == 1)
					dataAsHex = dataAsHex.concat("0"); // NOI18N
				dataAsHex = dataAsHex.concat(Long.toHexString(data));
			}

			for (j = 0; j < 8; j++)
				buf[bufPtr + j] = dataAsHex.charAt(j);

			//  Print the character translation at the end of the print line
			bufPtr = CHAR_START + (word * 4);
			for (j = 0; j < 4; j++)
			{
				try
				{
					if (Character.isLetterOrDigit((char)rawBytes[i + j]))
						buf[bufPtr + j] = (char)rawBytes[i + j];
					else
						buf[bufPtr + j] = '.';
				}
				catch (ArrayIndexOutOfBoundsException e)
				{
					buf[bufPtr + j] = '_';
				}

			}
			word++;

			//  Print the line to the stream
			if (i != 0 && (word % WORDS_PER_LINE) == 0)
			{
				HexConverter.overlayOffsets(buf, startPos);

				startPos = i + 4;
				resultString = resultString.concat(new String(buf, 0,
											   CHAR_START + (word * 5)));
				resultString = resultString.concat("\n"); // NOI18N
									
				word = 0;

				//  Clear out the buffer
				for (j = 0; j < 100; j++)
					buf[j] = ' ';
			}
		}

		//  Print what remains of the last line
		if (word != 0)
		{
			HexConverter.overlayOffsets(buf, startPos);

			resultString = resultString.concat(new
									String(buf, 0, CHAR_START + (word * 5)));
		}

		resultString = resultString.concat("\n"); // NOI18N

		return resultString;
	}

	private static void overlayOffsets(char buf[], int startPos)
	{
		String			startStr;
		String			startStrHex;
		int				j;

		startStr = StringScanner.getIntStr(startPos);
		startStrHex = Integer.toHexString(startPos);
		for (j = 0; j < 6; j++)
		{
			if (j + startStr.length() >= 6)
				buf[j] = startStr.charAt(startStr.length() - (6 - j));
			else
				buf[j] = ' ';
		}
		buf[6] = ' '; buf[7] = '0'; buf[8] = 'x';
		for (j = 0; j < 4; j++)
		{
			if (j + startStrHex.length() >= 4)
				buf[j + 9] = startStrHex.charAt(
								 startStrHex.length() - (4 - j));
			else
				buf[j + 9] = '0';
		}
	}
}
