/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * NumericConverter.java
 *
 * Created on March 21, 2003
 */

package com.sun.jdo.spi.persistence.support.sqlstore.utility;

import java.math.BigDecimal;
import java.math.BigInteger;

/**
 * This is a interface for numeric conversion to BigDecimal or BigInteger.
 *
 * @author Shing Wai Chan
 */
public interface NumericConverter {
     /**
      * The default policy for NumericConverter.
      */
     static final int DEFAULT_POLICY = 0;

     /**
      * To convert BigInteger to BigDecimal.
      * @param bInteger the BigInteger to be converted
      * @return converted BigDecimal
      */
     BigDecimal toBigDecimal(BigInteger bInteger);

     /**
      * To convert Double to BigDecimal.
      * @param d the Double to be converted
      * @return converted BigDecimal
      */
     BigDecimal toBigDecimal(Double d);

     /**
      * To convert Float to BigDecimal.
      * @param f the Float to be converted
      * @return converted BigDecimal
      */
     BigDecimal toBigDecimal(Float f);

     /**
      * To convert Number other than BigInteger, Double and Float to BigDecimal.
      * @param n the Number to be converted
      * @return converted BigDecimal
      */
     BigDecimal toBigDecimal(Number n);

     /**
      * To convert BigDecimal to BigInteger.
      * @param bDecimal the BigDecimal to be converted
      * @return converted BigInteger
      */
     BigInteger toBigInteger(BigDecimal bDecimal);

     /**
      * To convert Double to BigInteger.
      * @param d the Double to be converted
      * @return converted BigInteger
      */
     BigInteger toBigInteger(Double d);

     /**
      * To convert Float to BigInteger.
      * @param f the Float to be converted
      * @return converted BigInteger
      */
     BigInteger toBigInteger(Float f);

     /**
      * To convert Number other than BigDecimal, Double and Float to BigInteger.
      * @param n the Number to be converted
      * @return converted BigInteger
      */
     BigInteger toBigInteger(Number n);
}
