/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * @Version $Id: JmxMultiLruCache.java,v 1.4 2005/12/25 04:25:23 tcfujii Exp $
 * Created on May 4, 2005 02:30 PM
 */

package com.sun.appserv.util.cache.mbeans;

import com.sun.appserv.util.cache.MultiLruCache;
import com.sun.appserv.util.cache.Constants;
/**
 * This class provides implementation for JmxLruCache MBean
 *
 * @author Krishnamohan Meduri (Krishna.Meduri@Sun.com)
 *
 */
public class JmxMultiLruCache extends JmxBaseCache 
                              implements JmxMultiLruCacheMBean {

    private MultiLruCache multiLruCache;

    public JmxMultiLruCache(MultiLruCache multiLruCache, String name) {
        super(multiLruCache,name);
        this.multiLruCache = multiLruCache;
    }

    /**
     * Returns the number of entries that have been trimmed
     */
    public Integer getTrimCount() {
        return (Integer) multiLruCache.getStatByName(
                                        Constants.STAT_MULTILRUCACHE_TRIM_COUNT);
    }

    /**
     * Returns the size of each segment
     */
    public Integer getSegmentSize() {
        return (Integer) multiLruCache.getStatByName(
                                        Constants.STAT_MULTILRUCACHE_SEGMENT_SIZE);
    }

    /**
     * Returns the legnth of the segment list
     */
    public Integer[] getSegmentListLength() {
        return (Integer[]) multiLruCache.getStatByName(
                                        Constants.STAT_MULTILRUCACHE_SEGMENT_LIST_LENGTH);
    }
}
