/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.util.web;

public class URLPattern {
    
    // In Ascii table, New Line (NL) decimal value is 10
    private final static int NL = 10;
    // In Ascii table, Carriage Return (CR) decimal value is 13
    private final static int CR = 13;

    /**
     *  This method is used to check the validity of url pattern 
     *  according to the spec. It is used in the following places:
     *
     *  1. in WebResourceCollection 
     *  2. in ServletMapping
     *  3. in ServletFilterMapping
     *  (above three see Servlet Spec, from version 2.3 on, 
     *  Secion 13.2: "Rules for Processing the Deployment Descriptor")
     *
     *  4. in jsp-property-group 
     *  (see JSP.3.3: "JSP Property Groups")
     *
     *  @param urlPattern the url pattern
     *  @return false for invalid url pattern
     */
    public static boolean isValid(String urlPattern) {
        // URL Pattern should not contain New Line (NL) or
        // Carriage Return (CR)
        if (urlPattern.indexOf(NL) != -1  || urlPattern.indexOf (CR) != -1) {
            return false;
        }

        // Check validity for extension mapping
        if (urlPattern.startsWith("*.")) {
            if (urlPattern.indexOf('/') < 0) {
                return true;
            } else {
                return false;
            }
        }

        // check validity for path mapping
        if ( urlPattern.startsWith("/") && urlPattern.indexOf("*.") < 0) {
            return true;
        } else {
            return false;
        }

    }
}
