/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import javax.persistence.ManyToMany;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;

import oracle.toplink.essentials.mappings.ManyToManyMapping;

/**
 * A many to many relationship accessor.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class ManyToManyAccessor extends CollectionAccessor {    
    /**
     * INTERNAL:
     */
    public ManyToManyAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        
        ManyToMany manyToMany = getAnnotation(ManyToMany.class);

        if (manyToMany != null) {
            setFetchType(manyToMany.fetch());
            setMappedBy(manyToMany.mappedBy());
            setCascadeTypes(manyToMany.cascade());
            setTargetEntity(manyToMany.targetEntity());
        }
    }
    
    /**
     * INTERNAL:
     */
	public boolean isManyToMany() {
        return true;
    }
    
    /**
     * INTERNAL:
     * Process a @ManyToMany or many-to-many element into a TopLink MnayToMany 
     * mapping.
     */
    public void process() {
        // Create and initialize our mapping.
        ManyToManyMapping mapping = new ManyToManyMapping();
        populateCollectionMapping(mapping, m_logger.MANY_TO_MANY_MAPPING_REFERENCE_CLASS);

        if (m_mappedBy.equals("")) { 
            // Processing the owning side of a M-M that is process a join table.
            processJoinTable(getJoinTable(), mapping);
        } else {
            // We are processing the a non-owning side of a M-M. Must set the
            // mapping read-only.
            mapping.setIsReadOnly(true);
            
            // Get the owning mapping from the reference descriptor metadata.
            ManyToManyMapping ownerMapping = null;
            if (getOwningMapping().isManyToManyMapping()){
            	ownerMapping = (ManyToManyMapping)getOwningMapping();
            }else {
            	//gf730 - If improper mapping encountered, throw an exception  
            	getValidator().throwIvalidMappingEncountered(getJavaClass(), getReferenceClass());
            }

            // Set the relation table name from the owner.
	        mapping.setRelationTableName(ownerMapping.getRelationTableName());
	             
	        // Add all the source foreign keys we found on the owner.
	        mapping.setSourceKeyFields(ownerMapping.getTargetKeyFields());
	        mapping.setSourceRelationKeyFields(ownerMapping.getTargetRelationKeyFields());
	            
	        // Add all the target foreign keys we found on the owner.
	        mapping.setTargetKeyFields(ownerMapping.getSourceKeyFields());
	        mapping.setTargetRelationKeyFields(ownerMapping.getSourceRelationKeyFields());
        }

        // Add the mapping to the descriptor.
        m_descriptor.addMapping(mapping);
    }
}
