/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.util.Map;

import javax.persistence.OneToMany;

import oracle.toplink.essentials.internal.helper.DatabaseField;

import oracle.toplink.essentials.mappings.OneToOneMapping;
import oracle.toplink.essentials.mappings.OneToManyMapping;
import oracle.toplink.essentials.mappings.ManyToManyMapping;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;

/**
 * A OneToMany relationship accessor.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class OneToManyAccessor extends CollectionAccessor {
    /**
     * INTERNAL:
     */
    public OneToManyAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        
        // Process the annotation specifics if there is one, otherwise the 
        // defaults use the defaults which are initialized in the super class.
        OneToMany oneToMany = getAnnotation(OneToMany.class);
        
        if (oneToMany != null) {
            setFetchType(oneToMany.fetch());
            setMappedBy(oneToMany.mappedBy());
            setCascadeTypes(oneToMany.cascade());
            setTargetEntity(oneToMany.targetEntity());
        } 
    }
    
    /**
     * INTERNAL:
     */
	public boolean isOneToMany() {
        return true;
    }
    
    /**
     * INTERNAL:
     * Process an @OneToMany or one-to-many element into a TopLink OneToMany 
     * mapping. If a JoinTable is found however, we must create a ManyToMany 
     * mapping.
     */
    public void process() {
        String mappedBy = getMappedBy();
        
        // Should be treated as a uni-directional mapping using a join table.
        if (mappedBy.equals("")) {
            // If we find a JoinColumn(s), then throw an exception.
            if (hasJoinColumn() || hasJoinColumns()) {
                getValidator().throwUniDirectionalOneToManyHasJoinColumnSpecified(getJavaClass(), getAttributeName());
            }
            
            // Create a M-M mapping and populate it from the OneToMany.
            ManyToManyMapping mapping = new ManyToManyMapping();
            populateCollectionMapping(mapping, m_logger.ONE_TO_MANY_MAPPING_REFERENCE_CLASS);
            
            // Process the @JoinTable.
            processJoinTable(getJoinTable(), mapping);
            
            // Add the mapping to the descriptor.
            m_descriptor.addMapping(mapping);
        } else {
            // Create a 1-M mapping and populate it from the @OneToMany.
            OneToManyMapping mapping = new OneToManyMapping();
            populateCollectionMapping(mapping, m_logger.ONE_TO_MANY_MAPPING_REFERENCE_CLASS);
            
            // Non-owning side, process the foreign keys from the owner.
			OneToOneMapping ownerMapping = null;
            if (getOwningMapping().isOneToOneMapping()){ 
            	ownerMapping = (OneToOneMapping)getOwningMapping();
            }else {
				//gf730 - If improper mapping encountered, throw an exception
            	getValidator().throwIvalidMappingEncountered(getJavaClass(), getReferenceClass()); 
            }
                
            Map<DatabaseField, DatabaseField> keys = ownerMapping.getSourceToTargetKeyFields();
            for (DatabaseField fkField : keys.keySet()) {
                mapping.addTargetForeignKeyField(fkField, keys.get(fkField));
            }   
            
            // Add the mapping to the descriptor.
            m_descriptor.addMapping(mapping);
        }
    }
}
