/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import javax.persistence.FetchType;
import javax.persistence.OneToOne;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.mappings.OneToOneMapping;

/**
 * A one to one relationship accessor. 
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class OneToOneAccessor extends ObjectAccessor {    
    /**
     * INTERNAL:
     */
    public OneToOneAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        
        // Process the annotation specifics if there is one, otherwise the 
        // defaults use the defaults which are initialized in the super class.
        OneToOne oneToOne = getAnnotation(OneToOne.class);
        
        if (oneToOne != null) {
            setFetchType(oneToOne.fetch());
            setMappedBy(oneToOne.mappedBy());
            setIsOptional(oneToOne.optional());
            setCascadeTypes(oneToOne.cascade());
            setTargetEntity(oneToOne.targetEntity());
        }
    }
    
    /**
     * INTERNAL:
     */
	public boolean isOneToOne() {
        return true;
    }
    
    /**
     * INTERNAL:
     * Process a @OneToOne or one-to-one element into a TopLink OneToOne 
     * mapping.
     */
    public void process() {
        // Figure out the referenceClass and set it on the mapping.
        setReferenceClass(getTargetEntity(), m_logger.ONE_TO_ONE_MAPPING_REFERENCE_CLASS);
        
        // Initialize our mapping now with what we found.
        OneToOneMapping mapping = initOneToOneMapping();
        
        if (m_mappedBy.equals("")) {
            // Owning side, look for JoinColumns or PrimaryKeyJoinColumns.
            processOwningMappingKeys(mapping);
        } else {
			
            // Non-owning side, process the foreign keys from the owner.
            OneToOneMapping ownerMapping = null;
            if (getOwningMapping().isOneToOneMapping()){
            	ownerMapping = (OneToOneMapping)getOwningMapping();
            }else {
            	//gf730 - If improper mapping encountered, throw an exception  
            	getValidator().throwIvalidMappingEncountered(getJavaClass(), getReferenceClass());
            }

            mapping.setSourceToTargetKeyFields(ownerMapping.getTargetToSourceKeyFields());
            mapping.setTargetToSourceKeyFields(ownerMapping.getSourceToTargetKeyFields());
        }
        
        // Add the mapping to the descriptor.
        m_descriptor.addMapping(mapping);
    }
}
