/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns;

import java.util.List;
import java.util.ArrayList;

import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;

/**
 * Object to hold onto join column metadata.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class MetadataPrimaryKeyJoinColumns {
    private String m_sourceTableName;
    private String m_targetTableName;
    protected List<MetadataPrimaryKeyJoinColumn> m_pkJoinColumns;
    
    /**
     * INTERNAL:
     */
    public MetadataPrimaryKeyJoinColumns(String sourceTableName, String targetTableName) {
        m_sourceTableName = sourceTableName;
        m_targetTableName = targetTableName;
        m_pkJoinColumns = new ArrayList<MetadataPrimaryKeyJoinColumn>();
    }
    
    /**
     * INTERNAL:
     */
    public MetadataPrimaryKeyJoinColumns(PrimaryKeyJoinColumn[] primaryKeyJoinColumns, String sourceTableName, String targetTableName) {
        this(sourceTableName, targetTableName);
        
        // Process the primary key join column array.
        for (PrimaryKeyJoinColumn pkJoinColumn : primaryKeyJoinColumns) {
            m_pkJoinColumns.add(new MetadataPrimaryKeyJoinColumn(pkJoinColumn, sourceTableName, targetTableName));
        }
    }
    
    /**
     * INTERNAL:
     */
    public MetadataPrimaryKeyJoinColumns(PrimaryKeyJoinColumns primaryKeyJoinColumns, PrimaryKeyJoinColumn primaryKeyJoinColumn, String sourceTableName, String targetTableName) {
        this(sourceTableName, targetTableName);
        
        // Process all the primary key join columns first.
        if (primaryKeyJoinColumns != null) {
            for (PrimaryKeyJoinColumn pkJoinColumn : primaryKeyJoinColumns.value()) {
                m_pkJoinColumns.add(new MetadataPrimaryKeyJoinColumn(pkJoinColumn, sourceTableName, targetTableName));
            }
        }
        
        // Process the single primary key join column second.
        if (primaryKeyJoinColumn != null) {
            m_pkJoinColumns.add(new MetadataPrimaryKeyJoinColumn(primaryKeyJoinColumn, sourceTableName, targetTableName));
        }
    }
    
    /**
     * INTERNAL:
     */
    public List<MetadataPrimaryKeyJoinColumn> values() {
        // If no primary key join columns are specifed, add a default one.
        if (m_pkJoinColumns.isEmpty()) {
            m_pkJoinColumns.add(new MetadataPrimaryKeyJoinColumn(m_sourceTableName, m_targetTableName));
        }
        
        return m_pkJoinColumns;
    }
    
    /**
     * INTERNAL:
     */
    public boolean loadedFromXML() {
        return false;
    }
    
    /**
     * INTERNAL:
     */
    public int size() {
        return m_pkJoinColumns.size();
    }
}
