/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.EmbeddedAccessor;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataClass;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.columns.XMLColumn;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLConstants;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;

import oracle.toplink.essentials.mappings.AggregateObjectMapping;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * An XML extended embedded relationship accessor.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class XMLEmbeddedAccessor extends EmbeddedAccessor {    
    protected Node m_node;
    protected XMLHelper m_helper;
    
    /**
     * INTERNAL:
     */
    public XMLEmbeddedAccessor(MetadataAccessibleObject accessibleObject, Node node, XMLClassAccessor classAccessor, boolean isEmbeddedId) {
        super(accessibleObject, classAccessor, isEmbeddedId);
        m_node = node;
        m_helper = classAccessor.getHelper();
    }
    
    /**
     * INTERNAL: (OVERRIDE)
     */
    protected void processAttributeOverrides(AggregateObjectMapping mapping) {
        NodeList nodes = m_helper.getNodes(m_node, XMLConstants.ATTRIBUTE_OVERRIDE);
        
    	if (nodes != null) {
    		for (int i = 0; i < nodes.getLength(); i++) {
                processAttributeOverride(mapping, new XMLColumn(nodes.item(i), m_helper, getAnnotatedElement()));
    		}
    	}
        
        // WIP should we look on the class or not?
    }
    
    /**
     * INTERNAL: (OVERRIDE)
     * Fast track processing a ClassAccessor for the given descriptor. 
     * Inheritance root classes and embeddables may be fast tracked.
     * 
     * NOTE: The class passed in may not have any XML representation. If so,
     * pass up to the parent.
     * 
     * WIP ... shared code ... move to XMLAccessorHelper.
     */
    protected ClassAccessor processAccessor(MetadataDescriptor descriptor) {
        Node node = m_helper.locateEntityNode(descriptor.getJavaClass());
        
        if (node != null) {
            XMLClassAccessor accessor = new XMLClassAccessor(new MetadataClass(descriptor.getJavaClass()), node, m_helper, m_processor, descriptor);
            descriptor.setClassAccessor(accessor);
            accessor.process();
            accessor.setIsProcessed();
            return accessor;
        } else {
            return super.processAccessor(descriptor);
        }
    }
}
