/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.security;

import java.security.PrivilegedExceptionAction;

public class PrivilegedGetDeclaredField implements PrivilegedExceptionAction {

    private Class javaClass;
    private String fieldName;
    private boolean shouldSetAccessible;
    
    public PrivilegedGetDeclaredField(Class javaClass, String fieldName, boolean shouldSetAccessible) {
        this.javaClass = javaClass;
        this.fieldName = fieldName;
        this.shouldSetAccessible = shouldSetAccessible;
    }

    public Object run() throws NoSuchFieldException {
        return PrivilegedAccessHelper.getDeclaredField(javaClass, fieldName, shouldSetAccessible);
    }

}
