/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
package com.sun.gjc.spi;

import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnection;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

/**
 * ConnectionManager implementation for Generic JDBC Connector.
 *
 * @version	1.0, 02/07/31
 * @author	Binod P.G
 */
public class ConnectionManager implements javax.resource.spi.ConnectionManager{ 

    /**
     * Returns a <code>Connection </code> object to the <code>ConnectionFactory</code>
     *
     * @param	mcf	<code>ManagedConnectionFactory</code> object.
     * @param	info	<code>ConnectionRequestInfo</code> object.
     * @return	A <code>Connection</code> Object.
     * @throws	ResourceException In case of an error in getting the <code>Connection</code>.
     */
    public Object allocateConnection(ManagedConnectionFactory mcf,
    				     ConnectionRequestInfo info) 
    				     throws ResourceException {
	ManagedConnection mc = mcf.createManagedConnection(null, info);
	return mc.getConnection(null, info);    				     
    }
    
    /*
     * This class could effectively implement Connection pooling also.
     * Could be done for FCS.
     */
}