/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.gjc.spi;

import com.sun.gjc.spi.ManagedConnection;
import java.sql.SQLException;
import javax.resource.ResourceException;

import com.sun.logging.*;
import java.util.logging.Logger;
import java.util.logging.Level;
/**
 * <code>ManagedConnectionMetaData</code> implementation for Generic JDBC Connector.
 *
 * @version	1.0, 02/08/03
 * @author	Evani Sai Surya Kiran
 */
public class ManagedConnectionMetaData implements javax.resource.spi.ManagedConnectionMetaData {

    private java.sql.DatabaseMetaData dmd = null;
    private ManagedConnection mc;

    private static Logger _logger;
    static {
        _logger = LogDomains.getLogger( LogDomains.RSR_LOGGER );
    }
    private boolean debug = false;
    /**
     * Constructor for <code>ManagedConnectionMetaData</code>
     *
     * @param	mc	<code>ManagedConnection</code>
     * @throws	<code>ResourceException</code>	if getting the DatabaseMetaData object fails
     */
    public ManagedConnectionMetaData(ManagedConnection mc) throws ResourceException {
        try {
            this.mc = mc;
            dmd = mc.getActualConnection().getMetaData();
        } catch(SQLException sqle) {
	    _logger.log(Level.SEVERE, "jdbc.exc_md");
            throw new ResourceException(sqle.getMessage());
        }
    }
    
    /**
     * Returns product name of the underlying EIS instance connected
     * through the ManagedConnection.
     *
     * @return	Product name of the EIS instance
     * @throws	<code>ResourceException</code>
     */
    public String getEISProductName() throws ResourceException {
        try {
            return dmd.getDatabaseProductName();
        } catch(SQLException sqle) {
	    _logger.log(Level.SEVERE, "jdbc.exc_eis_prodname", sqle);
            throw new ResourceException(sqle.getMessage());
        }
    }
    
    /**
     * Returns product version of the underlying EIS instance connected
     * through the ManagedConnection.
     *
     * @return	Product version of the EIS instance
     * @throws	<code>ResourceException</code>
     */
    public String getEISProductVersion() throws ResourceException {
        try {
            return dmd.getDatabaseProductVersion();
        } catch(SQLException sqle) {
	    _logger.log(Level.SEVERE, "jdbc.exc_eis_prodvers", sqle);
            throw new ResourceException(sqle.getMessage(), sqle.getMessage());
        }
    }
    
    /**
     * Returns maximum limit on number of active concurrent connections
     * that an EIS instance can support across client processes.
     *
     * @return	Maximum limit for number of active concurrent connections
     * @throws	<code>ResourceException</code>
     */
    public int getMaxConnections() throws ResourceException {
        try {
            return dmd.getMaxConnections();
        } catch(SQLException sqle) {
	    _logger.log(Level.SEVERE, "jdbc.exc_eis_maxconn");
            throw new ResourceException(sqle.getMessage());
        }
    }
    
    /**
     * Returns name of the user associated with the ManagedConnection instance. The name
     * corresponds to the resource principal under whose whose security context, a connection
     * to the EIS instance has been established.
     *
     * @return	name of the user
     * @throws	<code>ResourceException</code>
     */
    public String getUserName() throws ResourceException {
        javax.resource.spi.security.PasswordCredential pc = mc.getPasswordCredential();
        if(pc != null) {
            return pc.getUserName();
        }
        
        return mc.getManagedConnectionFactory().getUser();
    }
}
