/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
package com.sun.jts.jta;

import java.util.*;
import javax.transaction.Synchronization;

import org.omg.CORBA.*;
import org.omg.CosTransactions.*;
import org.omg.PortableServer.POA;
import com.sun.jts.CosTransactions.Configuration;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

/**
 * An implementation of org.omg.CosTransactions.Synchronization
 * this object is activated at creation time and de-activated
 * when after_completion is called
 *
 * @author Tony Ng
 */
public class SynchronizationImpl extends SynchronizationPOA
        implements org.omg.CosTransactions.Synchronization {

    private Vector syncs;
    private Vector interposedSyncs;
    private POA poa;
    private org.omg.CosTransactions.Synchronization corbaRef = null;
    private TransactionState state = null;
	/*
		Logger to log transaction messages
	*/  
    static Logger _logger = LogDomains.getLogger(LogDomains.TRANSACTION_LOGGER);

    public SynchronizationImpl() {
        syncs = new Vector();
        interposedSyncs = new Vector();
        poa = Configuration.getPOA("transient"/*#Frozen*/);
    }

    public SynchronizationImpl(TransactionState state) {
        this();
        this.state = state;
    }

    public void addSynchronization(Synchronization sync, 
                                   boolean interposed) {
        if (!interposed)
            syncs.addElement(sync);
        else
            interposedSyncs.addElement(sync);
    }

    public void before_completion() {
        // Regular syncs first then the interposed syncs
        Enumeration e = syncs.elements();
        while (e.hasMoreElements()) {
            Synchronization sync = (Synchronization) e.nextElement();
            try {
                sync.beforeCompletion();
            } catch (RuntimeException rex) {
                try {
                    state.setRollbackOnly();
                } catch (Exception ex1) {
		    _logger.log(Level.WARNING,
		        "jts.unexpected_error_occurred_in_after_completion",ex1);
                }
		_logger.log(Level.WARNING,
		    "jts.unexpected_error_occurred_in_after_completion",rex);
            } catch (Exception ex) {
				_logger.log(Level.WARNING,
						"jts.unexpected_error_occurred_in_after_completion",ex);
            }
        }
        Enumeration e1 = interposedSyncs.elements();
        while (e1.hasMoreElements()) {
            Synchronization sync = (Synchronization) e1.nextElement();
            try {
                sync.beforeCompletion();
            } catch (RuntimeException rex) {
                try {
                    state.setRollbackOnly();
                } catch (Exception ex1) {
		    _logger.log(Level.WARNING,
		        "jts.unexpected_error_occurred_in_after_completion",ex1);
                }
		_logger.log(Level.WARNING,
		    "jts.unexpected_error_occurred_in_after_completion",rex);
            } catch (Exception ex) {
				_logger.log(Level.WARNING,
						"jts.unexpected_error_occurred_in_after_completion",ex);
            }
        }
        state.beforeCompletion();
    }

    public void after_completion(Status status) {
        try {
            int result = TransactionManagerImpl.mapStatus(status);
            // Interposed Syncs First and then the regular syncs
            Enumeration e1 = interposedSyncs.elements();
            while (e1.hasMoreElements()) {
                Synchronization sync = (Synchronization) e1.nextElement();
                try {
                    sync.afterCompletion(result);
                } catch (Exception ex) {
					_logger.log(Level.WARNING,
							"jts.unexpected_error_occurred_in_after_completion",ex);
                }
            }
            Enumeration e = syncs.elements();
            while (e.hasMoreElements()) {
                Synchronization sync = (Synchronization) e.nextElement();
                try {
                    sync.afterCompletion(result);
                } catch (Exception ex) {
					_logger.log(Level.WARNING,
							"jts.unexpected_error_occurred_in_after_completion",ex);
                }
            }
        } finally {
            try {
                // deactivate object
                if (corbaRef != null) {
                    if (poa == null) {
                        poa = Configuration.getPOA("transient"/*#Frozen*/);
                    }
                    poa.deactivate_object(poa.reference_to_id(corbaRef));
                }
            } catch (Exception ex) {
				_logger.log(Level.WARNING,
						"jts.unexpected_error_occurred_in_after_completion",ex);
            }
        }
    }

    public org.omg.CosTransactions.Synchronization getCORBAReference() {
        if (poa == null) {
            poa = Configuration.getPOA("transient"/*#Frozen*/);
        }

        if (corbaRef == null) {
            try {
                poa.activate_object(this);
                corbaRef = SynchronizationHelper.narrow(
                            poa.servant_to_reference(this));
                //corbaRef = (org.omg.CosTransactions.Synchronization) this;
            } catch (Exception ex) {
				_logger.log(Level.SEVERE,
						"jts.unexpected_error_in_getcorbareference",ex);
            }
        }

        return corbaRef;
    }

    /*
     * These methods are there to satisy the compiler. At some point
     * when we move towards a tie based model, the org.omg.Corba.Object
     * interface method implementation below shall be discarded.
     */

    private static org.omg.CORBA.NO_IMPLEMENT no_implement =
        new org.omg.CORBA.NO_IMPLEMENT("This is a locally constrained object.");


    public org.omg.CORBA.Object _duplicate() {
        throw no_implement;
    }

    public void _release() {
        throw no_implement;
    }

    public boolean _is_a(String repository_id) {
        throw no_implement;
    }

    public boolean _is_equivalent(org.omg.CORBA.Object that) {
        throw no_implement;
    }

    public boolean _non_existent() {
        throw no_implement;
    }

    public int _hash(int maximum) {
        throw no_implement;
    }

    public Request _request(String operation) {
        throw no_implement;
    }

    public Request _create_request(Context ctx,
				   String operation,
				   NVList arg_list,
				   NamedValue result) {
        throw no_implement;
    }

    public Request _create_request(Context ctx,
				   String operation,
				   NVList arg_list,
				   NamedValue result,
				   ExceptionList exceptions,
				   ContextList contexts) {
        throw no_implement;
    }

    public org.omg.CORBA.Object _get_interface_def() {
        throw no_implement;
    }

    public org.omg.CORBA.Policy _get_policy(int policy_type) {
        throw no_implement;
    }

    public org.omg.CORBA.DomainManager[] _get_domain_managers() {
        throw no_implement;
    }

    public org.omg.CORBA.Object _set_policy_override(
            org.omg.CORBA.Policy[] policies,
            org.omg.CORBA.SetOverrideType set_add) {
        throw no_implement;
    }
}
