/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * RoleMapElementTableModel.java
 *
 * Created on March 18, 2002, 3:14 PM
 */

package com.sun.enterprise.tools.common.properties;

import java.util.*;
import com.sun.enterprise.tools.common.util.diagnostics.Reporter;

/**
 *
 * @author  vkraemer
 * @version 
 */
public class RoleMapElementTableModel extends javax.swing.table.AbstractTableModel{

    RoleMapElement v = null;
    
    private static java.util.ResourceBundle bundle =
        java.util.ResourceBundle.getBundle("com.sun.enterprise.tools.common.properties.Bundle"); //NOI18N
    
    /** Creates new RoleMapElementTableModel */
    public RoleMapElementTableModel(RoleMapElement rm) {
        v = rm;
    }

    public java.lang.Object getValueAt(int param, int param1) {
        Object retVal = null; 
        if (param1 != 3)
            retVal = "";   // NOI18N
        if (param < v.getLength())
            retVal = v.getAttributeDetail(param, param1); //NOI18N
        return retVal;
        //        return ra.getAttributeValue("PropertyElement", param, intToAttribute(param1)); //NOI18N
    }
    
    public int getRowCount() {
        return v.getLength() + 1;
    }
    
    public int getColumnCount() {
        return v.getWidth();
    }
    
    
    public boolean isCellEditable(int row, int col) {
        return true;
    }
    
    public void setValueAt(Object val, int row, int col) {
        if (col == 3)
            Reporter.info("val size = " + ((Vector)val).size() + " row = " + row + " column = " + col);
        int pre = v.getLength();
        v.setAttributeDetail(val, row, col); //NOI18N
        if (v.getLength() < pre) {
            Reporter.info("fireTableRowsDeleted");   //NOI18N
//            fireTableStructureChanged();
            fireTableRowsDeleted(row, row);
        }
    }
    
    public String getColumnName(int col) {
        if (0 == col) 
            return bundle.getString("COL_HEADER_BE_USERNAME");
        if (1 == col)
            return bundle.getString("COL_HEADER_BE_PASSWORD");
        if (2 == col) 
            return bundle.getString("COL_HEADER_BE_CREDENTIAL");
        if (3 == col)
            return bundle.getString("COL_HEADER_CONTAINER_USERNAMES");
        throw new RuntimeException(bundle.getString("COL_HEADER_ERR_ERR_ERR"));
    }
    
    public static void main(String args[]) {
        RoleMapElement pe = new RoleMapElement(args);
        //if (null == args || 0 == args.length) {
        javax.swing.JTable tab = new javax.swing.JTable(new RoleMapElementTableModel(pe));
        javax.swing.table.TableColumnModel tcm = tab.getColumnModel();
        javax.swing.table.TableColumn tc = tcm.getColumn(1);
        //PasswordRenderEdit pre1 = new PasswordRenderEdit();
        PasswordRender pre2 = new PasswordRender();
        tc.setCellEditor(new javax.swing.DefaultCellEditor(new javax.swing.JPasswordField()));
        tc.setCellRenderer(pre2);
        javax.swing.JScrollPane sp = new javax.swing.JScrollPane(tab);
        javax.swing.JFrame f = new javax.swing.JFrame();
        f.addWindowListener(new CloseTestWindow(pe));
        f.getContentPane().add(sp);
        f.show();
    }
    
    static class CloseTestWindow extends java.awt.event.WindowAdapter {
        private RoleMapElement myRM;
        public CloseTestWindow(RoleMapElement rm) {
            myRM = rm;
        }
        public void windowClosing(java.awt.event.WindowEvent e) {
            System.out.println(myRM.dumpIt()); //NOI18N
            System.exit(0);
        }
    }
    
}
