/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * GenericTable.java
 *
 * Created on February 21, 2001, 01:23 AM
 */

package com.sun.enterprise.tools.common.ui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import com.sun.enterprise.tools.common.util.diagnostics.Reporter;

/**
 *
 * @author  bnevins
 * @version 1.0
 *
 * Generic Panel & Model for getting tables of strings from user
 */

public abstract class GenericTable extends JPanel
{
	public GenericTable()
	{
	}

	//////////////////////////////////////////////////////////////

	public void setGenericTableInfo(GenericTableInfo gti)
	{
		Reporter.assertIt(gti); //NOI18N
		theModel = new GenericTableModel(gti);
		theTable = new JTable(theModel);
		add(new JScrollPane(theTable));
		//setViewportView(new JTable(new GenericTableModel(gti)));
	}

	//////////////////////////////////////////////////////////////

	public Object getPropertyValue() throws java.lang.IllegalStateException 
	{
		return saveData();
	}

	//////////////////////////////////////////////////////////////

	protected GenericTableModel getModel()
	{
		return theModel;
	}

	//////////////////////////////////////////////////////////////

	protected JTable getJTable()
	{
		return theTable;
	}

	//////////////////////////////////////////////////////////////

	public abstract Object saveData();

	//////////////////////////////////////////////////////////////
	
	private JTable 				theTable 	= null;
	private	GenericTableModel	theModel	= null;
}
