/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.gui;

import java.awt.*;
import java.awt.image.ImageObserver;

// Referenced classes of package com.sun.wizards.awt:
//            InsetsPanel

public class ImagePanel extends InsetsPanel
{

    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 1;
    public static final int BOTTOM = 3;
    protected Image image;
    protected int hAlign;
    protected int vAlign;
    protected boolean loaded;

    public ImagePanel()
    {
        image = null;
        hAlign = 2;
        vAlign = 2;
        loaded = false;
    }

    public ImagePanel(int i, int j)
    {
        image = null;
        hAlign = 2;
        vAlign = 2;
        loaded = false;
        hAlign = i;
        vAlign = j;
    }

    public ImagePanel(Insets insets)
    {
        //super(insets);
        image = null;
        hAlign = 2;
        vAlign = 2;
        loaded = false;
    }

    public ImagePanel(LayoutManager layoutmanager)
    {
        super(layoutmanager);
        image = null;
        hAlign = 2;
        vAlign = 2;
        loaded = false;
    }

    public Dimension getMinimumSize()
    {
        return getPreferredSize();
    }

    public Dimension getPreferredSize()
    {
        Dimension dimension = new Dimension(0, 0);
        if(image != null)
        {
            dimension.width = image.getWidth(this);
            dimension.height = image.getHeight(this);
        }
        return dimension;
    }

    public synchronized boolean imageUpdate(Image image1, int i, int j, int k, int l, int i1)
    {
        if((i & 0x20) != 0)
        {
            loaded = true;
            repaint();
            return false;
        } else
        {
            return true;
        }
    }

    public void paint(Graphics g)
    {
        super.paint(g);
        if(loaded)
        {
            int i = 0;
            int j = 0;
            int k = image.getWidth(this);
            int l = image.getHeight(this);
            Dimension dimension = getSize();
            g.setClip(0, 0, dimension.width, dimension.height);
            switch(hAlign)
            {
            case 1: // '\001'
                i = super.insets.left;
                break;

            case 2: // '\002'
                i = (dimension.width - (super.insets.left + super.insets.right) - k) / 2 + super.insets.left;
                break;

            case 3: // '\003'
                i = dimension.width - k - super.insets.right;
                break;
            }
            switch(vAlign)
            {
            case 1: // '\001'
                j = super.insets.top;
                break;

            case 2: // '\002'
                j = (dimension.height - (super.insets.top + super.insets.bottom) - l) / 2 + super.insets.top;
                break;

            case 3: // '\003'
                j = dimension.height - l - super.insets.bottom;
                break;
            }
            g.drawImage(image, i, j, this);
        }
    }

    public void setAlignment(int i, int j)
    {
        hAlign = i;
        vAlign = j;
    }

    public void setImage(Image image1)
    {
        loaded = false;
        image = image1;
        prepareImage(image1, this);
    }
}
