/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class MakeParserDB
extends Task {
    private static final Map levels = new HashMap(5);
    private static Method main;
    private File db;
    private File sources;
    private File nbroot;
    private String fieldlevel = "public-and-protected";
    private String methodlevel = "public-and-protected";
    private String classlevel = "public-and-protected";
    private static /* synthetic */ Class array$Ljava$lang$String;

    public void setDB(File f) {
        this.db = f;
    }

    public void setSources(File f) {
        this.sources = f;
    }

    public void setNbroot(File f) {
        this.nbroot = f;
    }

    public void setFieldlevel(Level l) {
        this.fieldlevel = l.getValue();
    }

    public void setMethodlevel(Level l) {
        this.methodlevel = l.getValue();
    }

    public void setClasslevel(Level l) {
        this.classlevel = l.getValue();
    }

    public void execute() throws BuildException {
        if (this.db == null || this.sources == null || this.nbroot == null) {
            throw new BuildException("Need to set db, sources, and nbroot attrs", this.location);
        }
        if (!this.sources.isDirectory() || !this.nbroot.isDirectory()) {
            throw new BuildException("sources and nbroot attrs must be existing dirs", this.location);
        }
        File db2 = new File(this.db.getAbsolutePath() + ".jcb");
        if (db2.isFile() && !MakeParserDB.newer(this.sources, db2.lastModified())) {
            this.log("The parser database " + db2 + " is already up-to-date, not rebuilding from " + this.sources);
            return;
        }
        try {
            String[] args = new String[]{this.sources.getAbsolutePath(), this.db.getAbsolutePath(), (String)levels.get(this.classlevel), (String)levels.get(this.fieldlevel), (String)levels.get(this.methodlevel)};
            this.log("Parsing " + this.sources + " into " + this.db + ".jc[bs] ...");
            ClassLoader origL = Thread.currentThread().getContextClassLoader();
            try {
                Method m = this.getMain(origL);
                Thread.currentThread().setContextClassLoader(m.getDeclaringClass().getClassLoader());
                m.invoke(null, new Object[]{args});
            }
            finally {
                Object var5_7 = null;
                Thread.currentThread().setContextClassLoader(origL);
            }
        }
        catch (Exception e) {
            throw new BuildException("Could not load updater class", (Throwable)e, this.location);
        }
        catch (LinkageError e) {
            throw new BuildException("Could not load updater class", (Throwable)e, this.location);
        }
    }

    private Method getMain(ClassLoader origL) throws Exception, LinkageError {
        if (main == null) {
            String[] cp = new String[]{"openide/netbeans/lib/openide.jar", "openide/execution/netbeans/modules/autoload/openide-execution.jar", "openide/io/netbeans/modules/autoload/openide-io.jar", "core/netbeans/lib/ext/boot.jar", "core/netbeans/lib/ext/xml-apis-1.0b2.jar", "core/netbeans/lib/ext/crimson-1.1.3.jar", "core/netbeans/lib/core.jar", "classfile/netbeans/modules/autoload/classfile.jar", "java/api/netbeans/modules/autoload/java-api.jar", "java/srcmodel/netbeans/modules/autoload/java-src-model.jar", "java/netbeans/modules/java.jar", "editor/netbeans/modules/editor.jar", "debuggercore/oldapi/netbeans/modules/autoload/openide-debugger.jar", "openide/compiler/netbeans/modules/autoload/openide-compiler.jar", "core/windows/netbeans/lib/core-windows.jar", "core/execution/netbeans/modules/autoload/core-execution.jar", "core/compiler/netbeans/modules/autoload/core-compiler.jar", "core/output/netbeans/modules/autoload/core-output.jar", "core/term/netbeans/modules/autoload/terminalemulator.jar"};
            URL[] urls = new URL[cp.length];
            int i = 0;
            while (i < cp.length) {
                File f = this.nbroot;
                StringTokenizer tok = new StringTokenizer(cp[i], "/");
                while (tok.hasMoreTokens()) {
                    f = new File(f, tok.nextToken());
                }
                if (!f.isFile()) {
                    throw new IOException("No such file for classpath: " + f);
                }
                urls[i] = f.toURL();
                ++i;
            }
            this.log("Classpath to load StandaloneJCDBCreator: " + Arrays.asList(urls), 3);
            URLClassLoader l = new URLClassLoader(urls, origL);
            System.setProperty("netbeans.security.nocheck", "true");
            System.setProperty("netbeans.full.hack", "true");
            Class<?> c = Class.forName("org.netbeans.modules.editor.java.StandaloneJCDBCreator", true, l);
            main = c.getMethod("main", array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = MakeParserDB.class$("[Ljava.lang.String;")));
        }
        return main;
    }

    private static boolean newer(File f, long t) {
        if (f.isFile()) {
            return f.lastModified() >= t;
        }
        if (f.isDirectory()) {
            File[] kids = f.listFiles(new FileFilter(){

                public boolean accept(File test) {
                    return test.isDirectory() || test.getName().endsWith(".java");
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            int i = 0;
            while (i < kids.length) {
                if (MakeParserDB.newer(kids[i], t)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        throw new IllegalArgumentException(f.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        levels.put("public-and-protected", "2");
        levels.put("all", "0");
        levels.put("not-private", "1");
        levels.put("public", "3");
        main = null;
    }

    public static class Level
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"public-and-protected", "all", "not-private", "public"};
        }
    }
}

