/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmaki;

import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class AjaxContext {
    private Writer out = null;
    private ServletRequest request = null;
    private ServletResponse response = null;
    private ServletContext ctx = null;
    private Map properties = null;
    private StringBuffer template = null;

    public AjaxContext(ServletContext ctx, ServletRequest req, ServletResponse res, Writer out, Map properties) {
        this.properties = properties;
        this.request = req;
        this.response = res;
        this.ctx = ctx;
        this.out = out;
    }

    public Writer getWriter() {
        return this.out;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getContext() {
        return this.ctx;
    }

    public void setTemplate(StringBuffer template) {
        this.template = template;
    }

    public String getString(String key) {
        if (this.properties.containsKey(key)) {
            return (String)this.properties.get(key);
        }
        return null;
    }

    public boolean getBoolean(String key) {
        if (this.properties.containsKey(key)) {
            return (Boolean)this.properties.get(key);
        }
        return false;
    }

    public Map getProperties() {
        return this.properties;
    }

    public StringBuffer getTemplate() {
        return this.template;
    }

    public String getInitParameter(String key) {
        return this.ctx.getInitParameter(key);
    }

    public Object getAttribute(String key) {
        return this.ctx.getAttribute(key);
    }

    public void setAttribute(String key, Object val) {
        this.ctx.setAttribute(key, val);
    }

    public void setRequestAttribute(String key, Object val) {
        this.request.setAttribute(key, val);
    }

    public Object getRequestAttribute(String key) {
        return this.request.getAttribute(key);
    }

    public URL getResource(String resource) throws MalformedURLException {
        return this.ctx.getResource(resource);
    }

    public String getContextPath() {
        return ((HttpServletRequest)this.request).getContextPath();
    }

    public String getScheme() {
        return ((HttpServletRequest)this.request).getScheme();
    }

    public String getRequestURI() {
        return ((HttpServletRequest)this.request).getRequestURI();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }
}

