/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/**
 *	This generated bean class IdentityAssertionTrust matches the DTD element identity-assertion-trust
 *
 */

package com.sun.enterprise.config.serverbeans;

import org.w3c.dom.*;
import org.netbeans.modules.schema2beans.*;
import java.beans.*;
import java.util.*;
import java.io.Serializable;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.util.i18n.StringManager;

// BEGIN_NOI18N

public class IdentityAssertionTrust extends ConfigBean implements Serializable
{

	static Vector comparators = new Vector();
	private static final org.netbeans.modules.schema2beans.Version runtimeVersion = new org.netbeans.modules.schema2beans.Version(4, 2, 0);

	static public final String TRUSTED_INTERMEDIATE = "TrustedIntermediate";
	static public final String TRUST_HANDLER = "TrustHandler";

	public IdentityAssertionTrust() {
		this(Common.USE_DEFAULT_VALUES);
	}

	public IdentityAssertionTrust(int options)
	{
		super(comparators, runtimeVersion);
		// Properties (see root bean comments for the bean graph)
		initPropertyTables(2);
		this.createProperty("trusted-intermediate", TRUSTED_INTERMEDIATE, Common.SEQUENCE_OR | 
			Common.TYPE_0_N | Common.TYPE_BEAN | Common.TYPE_KEY, 
			TrustedIntermediate.class);
		this.createAttribute(TRUSTED_INTERMEDIATE, "id", "Id", 
						AttrProp.CDATA | AttrProp.REQUIRED,
						null, null);
		this.createProperty("trust-handler", TRUST_HANDLER, Common.SEQUENCE_OR | 
			Common.TYPE_1 | Common.TYPE_BEAN | Common.TYPE_KEY, 
			TrustHandler.class);
		this.createAttribute(TRUST_HANDLER, "class-name", "ClassName", 
						AttrProp.CDATA | AttrProp.REQUIRED,
						null, null);
		this.initialize(options);
	}

	// Setting the default values of the properties
	void initialize(int options) {

	}

	// Get Method
	public TrustedIntermediate getTrustedIntermediate(int index) {
		return (TrustedIntermediate)this.getValue(TRUSTED_INTERMEDIATE, index);
	}

	// This attribute is an array, possibly empty
	public void setTrustedIntermediate(TrustedIntermediate[] value) {
		this.setValue(TRUSTED_INTERMEDIATE, value);
		if (value != null && value.length > 0) {
			// It's a mutually exclusive property.
			setTrustHandler(null);
		}
	}

	// Getter Method
	public TrustedIntermediate[] getTrustedIntermediate() {
		return (TrustedIntermediate[])this.getValues(TRUSTED_INTERMEDIATE);
	}

	// Return the number of properties
	public int sizeTrustedIntermediate() {
		return this.size(TRUSTED_INTERMEDIATE);
	}

	// Add a new element returning its index in the list
	public int addTrustedIntermediate(TrustedIntermediate value)
			throws ConfigException{
		return addTrustedIntermediate(value, true);
	}

	// Add a new element returning its index in the list with a boolean flag
	public int addTrustedIntermediate(TrustedIntermediate value, boolean overwrite)
			throws ConfigException{
		TrustedIntermediate old = getTrustedIntermediateById(value.getId());
		if(old != null) {
			throw new ConfigException(StringManager.getManager(IdentityAssertionTrust.class).getString("cannotAddDuplicate",  "TrustedIntermediate"));
		}
		return this.addValue(TRUSTED_INTERMEDIATE, value, overwrite);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	//
	public int removeTrustedIntermediate(TrustedIntermediate value){
		return this.removeValue(TRUSTED_INTERMEDIATE, value);
	}

	//
	// Remove an element using its reference
	// Returns the index the element had in the list
	// with boolean overwrite
	//
	public int removeTrustedIntermediate(TrustedIntermediate value, boolean overwrite)
			throws StaleWriteConfigException{
		return this.removeValue(TRUSTED_INTERMEDIATE, value, overwrite);
	}

	public TrustedIntermediate getTrustedIntermediateById(String id) {
	 if (null != id) { id = id.trim(); }
	TrustedIntermediate[] o = getTrustedIntermediate();
	 if (o == null) return null;

	 for (int i=0; i < o.length; i++) {
	     if(o[i].getAttributeValue(Common.convertName(ServerTags.ID)).equals(id)) {
	         return o[i];
	     }
	 }

		return null;
		
	}
	// This attribute is mandatory
	public void setTrustHandler(TrustHandler value) {
		this.setValue(TRUST_HANDLER, value);
		if (value != null) {
			// It's a mutually exclusive property.
			setTrustedIntermediate(null);
		}
	}

	// Get Method
	public TrustHandler getTrustHandler() {
		return (TrustHandler)this.getValue(TRUST_HANDLER);
	}

	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public TrustedIntermediate newTrustedIntermediate() {
		return new TrustedIntermediate();
	}

	/**
	 * Create a new bean using it's default constructor.
	 * This does not add it to any bean graph.
	 */
	public TrustHandler newTrustHandler() {
		return new TrustHandler();
	}

	/**
	* get the xpath representation for this element
	* returns something like abc[@name='value'] or abc
	* depending on the type of the bean
	*/
	protected String getRelativeXPath() {
	    String ret = null;
	    ret = "identity-assertion-trust";
	    return (null != ret ? ret.trim() : null);
	}

	/*
	* generic method to get default value from dtd
	*/
	public static String getDefaultAttributeValue(String attr) {
		if(attr == null) return null;
		attr = attr.trim();
	return null;
	}
	//
	public static void addComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.add(c);
	}

	//
	public static void removeComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.remove(c);
	}
	public void validate() throws org.netbeans.modules.schema2beans.ValidateException {
	}

	// Dump the content of this bean returning it as a String
	public void dump(StringBuffer str, String indent){
		String s;
		Object o;
		org.netbeans.modules.schema2beans.BaseBean n;
		str.append(indent);
		str.append("TrustedIntermediate["+this.sizeTrustedIntermediate()+"]");	// NOI18N
		for(int i=0; i<this.sizeTrustedIntermediate(); i++)
		{
			str.append(indent+"\t");
			str.append("#"+i+":");
			n = (org.netbeans.modules.schema2beans.BaseBean) this.getTrustedIntermediate(i);
			if (n != null)
				n.dump(str, indent + "\t");	// NOI18N
			else
				str.append(indent+"\tnull");	// NOI18N
			this.dumpAttributes(TRUSTED_INTERMEDIATE, i, str, indent);
		}

		str.append(indent);
		str.append("TrustHandler");	// NOI18N
		n = (org.netbeans.modules.schema2beans.BaseBean) this.getTrustHandler();
		if (n != null)
			n.dump(str, indent + "\t");	// NOI18N
		else
			str.append(indent+"\tnull");	// NOI18N
		this.dumpAttributes(TRUST_HANDLER, 0, str, indent);

	}
	public String dumpBeanNode(){
		StringBuffer str = new StringBuffer();
		str.append("IdentityAssertionTrust\n");	// NOI18N
		this.dump(str, "\n  ");	// NOI18N
		return str.toString();
	}}

// END_NOI18N

