/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/**
 *	This generated bean class TrustedIntermediate matches the DTD element trusted-intermediate
 *
 */

package com.sun.enterprise.config.serverbeans;

import org.w3c.dom.*;
import org.netbeans.modules.schema2beans.*;
import java.beans.*;
import java.util.*;
import java.io.Serializable;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.util.i18n.StringManager;

// BEGIN_NOI18N

public class TrustedIntermediate extends ConfigBean implements Serializable
{

	static Vector comparators = new Vector();
	private static final org.netbeans.modules.schema2beans.Version runtimeVersion = new org.netbeans.modules.schema2beans.Version(4, 2, 0);

	static public final String IP_ADDRESS = "IpAddress";
	static public final String DOMAIN_NAME = "DomainName";
	static public final String PRINCIPAL = "Principal";

	public TrustedIntermediate() {
		this(Common.USE_DEFAULT_VALUES);
	}

	public TrustedIntermediate(int options)
	{
		super(comparators, runtimeVersion);
		// Properties (see root bean comments for the bean graph)
		initPropertyTables(3);
		this.createProperty("ip-address", IP_ADDRESS, 
			Common.TYPE_1 | Common.TYPE_STRING | Common.TYPE_KEY, 
			String.class);
		this.createProperty("domain-name", DOMAIN_NAME, 
			Common.TYPE_0_1 | Common.TYPE_STRING | Common.TYPE_KEY, 
			String.class);
		this.createProperty("principal", PRINCIPAL, 
			Common.TYPE_0_1 | Common.TYPE_STRING | Common.TYPE_KEY, 
			String.class);
		this.initialize(options);
	}

	// Setting the default values of the properties
	void initialize(int options) {

	}

	/**
	* Return  the IpAddress of the Element trusted-intermediate
	*/
	public String getIpAddress() {
		return (String) getValue(ServerTags.IP_ADDRESS);
	}
	/**
	* Modify  the IpAddress of the Element trusted-intermediate
	* @param v the new value
	*/
	public void setIpAddress(String v){
		setValue(ServerTags.IP_ADDRESS, (null != v ? v.trim() : null));
		}
	/**
	* Return  the DomainName of the Element trusted-intermediate
	*/
	public String getDomainName() {
		return (String) getValue(ServerTags.DOMAIN_NAME);
	}
	/**
	* Modify  the DomainName of the Element trusted-intermediate
	* @param v the new value
	*/
	public void setDomainName(String v){
		setValue(ServerTags.DOMAIN_NAME, (null != v ? v.trim() : null));
		}
	/**
	* Return  the Principal of the Element trusted-intermediate
	*/
	public String getPrincipal() {
		return (String) getValue(ServerTags.PRINCIPAL);
	}
	/**
	* Modify  the Principal of the Element trusted-intermediate
	* @param v the new value
	*/
	public void setPrincipal(String v){
		setValue(ServerTags.PRINCIPAL, (null != v ? v.trim() : null));
		}
	/**
	* Getter for Id of the Element trusted-intermediate
	* @return  the Id of the Element trusted-intermediate
	*/
	public String getId() {
		return getAttributeValue(ServerTags.ID);
	}
	/**
	* Modify  the Id of the Element trusted-intermediate
	* @param v the new value
	* @throws StaleWriteConfigException if overwrite is false and file changed on disk
	*/
	public void setId(String v, boolean overwrite) throws StaleWriteConfigException {
		setAttributeValue(ServerTags.ID, v, overwrite);
	}
	/**
	* Modify  the Id of the Element trusted-intermediate
	* @param v the new value
	*/
	public void setId(String v) {
		setAttributeValue(ServerTags.ID, v);
	}
	/**
	* get the xpath representation for this element
	* returns something like abc[@name='value'] or abc
	* depending on the type of the bean
	*/
	protected String getRelativeXPath() {
	    String ret = null;
	    ret = "trusted-intermediate" + (canHaveSiblings() ? "[@id='" + getAttributeValue("id") +"']" : "") ;
	    return (null != ret ? ret.trim() : null);
	}

	/*
	* generic method to get default value from dtd
	*/
	public static String getDefaultAttributeValue(String attr) {
		if(attr == null) return null;
		attr = attr.trim();
	return null;
	}
	//
	public static void addComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.add(c);
	}

	//
	public static void removeComparator(org.netbeans.modules.schema2beans.BeanComparator c) {
		comparators.remove(c);
	}
	public void validate() throws org.netbeans.modules.schema2beans.ValidateException {
	}

	// Dump the content of this bean returning it as a String
	public void dump(StringBuffer str, String indent){
		String s;
		Object o;
		org.netbeans.modules.schema2beans.BaseBean n;
		str.append(indent);
		str.append("IpAddress");	// NOI18N
		str.append(indent+"\t");	// NOI18N
		str.append("<");	// NOI18N
		o = this.getIpAddress();
		str.append((o==null?"null":o.toString().trim()));	// NOI18N
		str.append(">\n");	// NOI18N
		this.dumpAttributes(IP_ADDRESS, 0, str, indent);

		str.append(indent);
		str.append("DomainName");	// NOI18N
		str.append(indent+"\t");	// NOI18N
		str.append("<");	// NOI18N
		o = this.getDomainName();
		str.append((o==null?"null":o.toString().trim()));	// NOI18N
		str.append(">\n");	// NOI18N
		this.dumpAttributes(DOMAIN_NAME, 0, str, indent);

		str.append(indent);
		str.append("Principal");	// NOI18N
		str.append(indent+"\t");	// NOI18N
		str.append("<");	// NOI18N
		o = this.getPrincipal();
		str.append((o==null?"null":o.toString().trim()));	// NOI18N
		str.append(">\n");	// NOI18N
		this.dumpAttributes(PRINCIPAL, 0, str, indent);

	}
	public String dumpBeanNode(){
		StringBuffer str = new StringBuffer();
		str.append("TrustedIntermediate\n");	// NOI18N
		this.dump(str, "\n  ");	// NOI18N
		return str.toString();
	}}

// END_NOI18N

