/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.webservice.monitoring.EndpointLifecycleListener;
import com.sun.enterprise.webservice.monitoring.Endpoint;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

/**
 *
 * @author Manisha Umbarje
 */
public class EndpointLifecycleListenerImpl implements EndpointLifecycleListener {
    
    /**
     * Internal handle to the logger instance
     */
    protected static final Logger logger =
        LogDomains.getLogger(LogDomains.SERVER_LOGGER);
    /**
     * Creates a new instance of EndpointLifecycleListenerImpl 
     */
    public EndpointLifecycleListenerImpl() {
    }
    
    
    /**
     * Notification of a new Web Service endpoint installation in the 
     * appserver. 
     * @param endpoint endpoint to register SOAPMessageListener if needed.
     */
    public void endpointAdded(Endpoint endpoint) {
            // End point added
        EndpointHelper.getInstance().registerEndpoint(endpoint);
    }
    
    /**
     * Notification of a Web Service endpoint removal from the appserver
     * @param endpoint handler to register SOAPMessageListener if needed.
     */
    public void endpointRemoved(Endpoint endpoint) {
        WebServiceEndpoint endpt = endpoint.getDescriptor();
        if(endpt == null)
            return;
        String endpointName = endpt.hasWsdlPort() ?
            endpt.getWsdlPort().getLocalPart() : endpt.getEndpointName();
        EndpointHelper.getInstance().unregisterEndpoint(
                endpt.getServiceName(), endpointName);
    }
}
