/*
 * TrustHandler.java
 *
 * Created on 14 Oct, 2007, 12:38:15 PM
 *
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.enterprise.security.auth;

import java.security.Principal;
import java.security.cert.X509Certificate;

/**
 *
 * Enables developers to provide custom implementation to enable sip containers
 * to determine if a network entity can be trusted and also enables formatting of
 * P-Asserted-Identity values.
 * eg: "Cullen Jennings" <sip:fluffy@cisco.com> value can be mapped/formatted to
 *      "CullenJ".
 */
public interface TrustHandler {

    /**
     * determines if the container can trust the network entity from which we received the message with P-Asserted-Identity
     * header. This method also validates if the identity that was used to secure(eg: SSL) the message is trusted.
     *
     * @param pAssertedValues P-Asserted-Identity header values
     * @param messageDirection "Incoming" if this method is invoked for a incoming request, "Outgoing" if the message is being sent out.
     * @param asserterAddress ipaddress/hostname of the network entity from which we received the SIP message
     * with P-Asserted-Identity header. Inorder to accept/use the values in P-Asserted-Identity
     * header the network entity should be a trusted.
     * @param securityid is the asserting security identity, if a secure connection is used then this
     * would be the java.security.cert.X509Certificate, else null.
     * @return true if we trust the networtid and the securityid.
     */
    public boolean isTrusted(String asserterAddress, String messageDirection,X509Certificate securityid, Principal[] pAssertedValues);

    /**
     *
     * converts values in to a format understood by the container/container backend eg: database, ldap etc.
     *
     * @param assrtId P-Asserted-Identity values.
     * @return P-Asserted-Identity values in a format understood by the container.
     */
    public Principal[] mapIdentity(Principal[] assrtId);
}