/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.clbadmin.reader.api;

import com.sun.enterprise.config.ConfigContext;


/**
 * Reader class to get information about load balancer configuration.
 *
 * @author Vijaya Gadhamsetty
 */
public interface LoadbalancerReader extends BaseReader {
    /*** Supported Attribute names for Load balancer **/
    public static final String RELOAD_INTERVAL = "reload-poll-interval-in-seconds";

    /**
     * Returns properties of the load balancer.
     * For example reload-poll-interval-in-seconds
     *
     * @return PropertyReader[]     array of properties
     */
    public PropertyReader[] getProperties() throws LbReaderException;

    /**
     * Returns the cluster info that are load balanced by this LB.
     *
     * @return ClusterReader        array of cluster readers
     */
    public ClusterReader[] getClusters() throws LbReaderException;

    public String getHttpPolicy() throws LbReaderException;

    public String getSipPolicy() throws LbReaderException;

    public String getDcrFile() throws LbReaderException;
}
