/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.clbadmin.reader.impl;

import com.sun.enterprise.config.serverbeans.ConvergedLbConfig;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;

import com.sun.logging.ee.EELogDomains;

import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.LbReaderException;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.LoadbalancerReader;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.PropertyReader;
import org.jvnet.glassfish.comms.admin.clbadmin.transform.PropertyVisitor;
import org.jvnet.glassfish.comms.admin.clbadmin.transform.Visitor;

import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * Provides property information relavant to Load balancer tier.
 *
 * @author Vijaya Gadhamsetty
 */
public class PropertyReaderImpl implements PropertyReader {
    // -- PRIVATE VARS ---
    private static final StringManager _localStrMgr = StringManager.getManager(PropertyReaderImpl.class);
    private String _value = null;
    private String _name = null;
    private String _description = null;

    // --- CTOR METHOD ------
    public PropertyReaderImpl(ConvergedLbConfig clbConfig, String propName) {
        if ((clbConfig == null) || (propName == null)) {
            String msg = _localStrMgr.getString("ConfigBeanAndNameNull");
            throw new IllegalArgumentException(msg);
        }

        setValue(clbConfig, propName);
    }

    public PropertyReaderImpl(ConvergedLbConfig clbConfig, String propName,
        String value) {
        if ((clbConfig == null) || (propName == null)) {
            String msg = _localStrMgr.getString("ConfigBeanAndNameNull");
            throw new IllegalArgumentException(msg);
        }

        _name = propName;
        _value = value;
    }

    // -- READER IMPLEMENTATION ----

    /**
     * Returns name of the property
     *
     * @return String           name of the property
     */
    public String getName() throws LbReaderException {
        return _name;
    }

    /**
     * Returns value of the property
     *
     * @return String           name of the value
     */
    public String getValue() throws LbReaderException {
        return _value;
    }

    /**
     * Returns description of the property
     *
     * @return String           description of the property
     */
    public String getDescription() throws LbReaderException {
        return _description;
    }

    // --- VISITOR IMPLEMENTATION ---
    public void accept(Visitor v) {
        PropertyVisitor pv = (PropertyVisitor) v;
        pv.visit(this);
    }

    // --- PRIVATE METHODS -----
    private void setValue(ConvergedLbConfig clbConfig, String name) {
        if (name.equals(LoadbalancerReader.RELOAD_INTERVAL)) {
            _value = clbConfig.getReloadPollIntervalInSeconds();
        } else {
            _value = clbConfig.getElementPropertyByName(name).getValue();

            if (_value == null) {
                String msg = _localStrMgr.getString("PropertyNotFound", name,
                        clbConfig.getName());
                throw new IllegalArgumentException(msg);
            }
        }

        _name = name;
    }
}
