/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.mbeans.extensions;

import com.sun.enterprise.admin.config.MBeanConfigInstanceNotFoundException;
import com.sun.enterprise.admin.mbeans.ConfigsMBean;
import com.sun.enterprise.admin.target.Target;

import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;

import javax.management.*;


public class SipConfigMBean extends ConfigsMBean {
    private ObjectName on;

    public SipConfigMBean() {
        super();
    }

    public ObjectName createSipListener(AttributeList attrList,
        Properties props, String targetName) throws MBeanException {
        final Target target = getTarget(targetName);

        //        check1ToN(target);
        ObjectName sipService = getSipServiceMBean(target);
        ObjectName mbean = (ObjectName) invoke1(sipService,
                "createSipListener", attrList, AttributeList.class.getName());
        setProperties(mbean, props);

        return mbean;
    }

    public boolean deleteSipListener(String listenerId, String targetName)
        throws MBeanException {
        final Target target = getTarget(targetName);

        //        check1ToN(target);
        final ObjectName sipService = getSipServiceMBean(target);
        invoke1(sipService, "removeSipListenerById", listenerId,
            String.class.getName());

        return true;
    }

    public ObjectName[] listSipListeners(String targetName)
        throws MBeanException {
        final Target target = getTarget(targetName);
        ObjectName sipService = getSipServiceMBean(target);
        ObjectName[] ret = (ObjectName[]) invoke0(sipService, "getSipListener");

        return ret;
    }

    public ObjectName getSipService(String targetName)
        throws MBeanException {
        return getChild("sip-service", null, targetName);
    }

    public ObjectName getSipListener(String listenerName, String targetName)
        throws MBeanException {
        return getChild("sip-listener", new String[] { listenerName },
            targetName);
    }

    /** The function is used to get the ssl element for the specified listenerName. If the ssl element
     *  does not exist then an MBeanConfigInstanceNotFoundException is thrown.
     */
    public ObjectName getSSL(String listenerName, String targetName)
        throws MBeanException {
        ObjectName sipListener = getSipListener(listenerName, targetName);

        try {
            return (ObjectName) invoke0(sipListener, "getSsl");
        } catch (MBeanException e) {
            if ((e.getTargetException() != null) &&
                    (e.getTargetException().getCause() instanceof MBeanConfigInstanceNotFoundException)) {
                return null;
            }

            throw e;
        }
    }

    protected ObjectName getSipServiceMBean(Target target)
        throws MBeanException {
        final ObjectName configMBean = getConfigMBean(target);
        ObjectName ret = (ObjectName) invoke0(configMBean, "getSipService");

        return ret;
    }
}
