/*
 * SessionManagerStatsImpl.java
 *
 * Created on 2007-okt-04, 16:18:20
 *
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.jvnet.glassfish.comms.admin.monitor;

import com.ericsson.ssa.container.NetworkManager;
import com.ericsson.ssa.container.OLDNetworkManager;
import com.ericsson.ssa.sip.Layer;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;


/**
 *
 * @author erapdan
 */
public class NetworkManagerStatsImpl implements NetworkManagerStats, SipStats {
    private MutableCountStatistic invalidSipMessages;
    private MutableCountStatistic receivedSipRequests;
    private MutableCountStatistic receivedSipResponses;
    private MutableCountStatistic sentSipRequests;
    private MutableCountStatistic sentSipResponses;
    private NetworkManager networkManager = null;
    private GenericStatsImpl baseStatsImpl;

    public NetworkManagerStatsImpl() {
        initializeStatistics();
        baseStatsImpl = new GenericStatsImpl(NetworkManagerStats.class, this);
    }

    public void setStatsProvider(Layer provider) {
        this.networkManager = (NetworkManager)provider;
    }

    private void initializeStatistics() {
        CountStatistic c;
        c = new CountStatisticImpl("InvalidSipMessages");
        invalidSipMessages = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("ReceivedSipRequests");
        receivedSipRequests = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("ReceivedSipResponses");
        receivedSipResponses = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("SentSipRequests");
        sentSipRequests = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("SentSipResponses");
        sentSipResponses = new MutableCountStatisticImpl(c);
    }

    public long getInvalidSipMessagesLong() {
        if (networkManager instanceof OLDNetworkManager) {
            return ((OLDNetworkManager) networkManager).getEasInvalidSipMessages();
        }

        return 0;
    }

    public long getReceivedSipRequestsLong() {
        if (networkManager instanceof OLDNetworkManager) {
            return ((OLDNetworkManager) networkManager).getEasReceivedSipRequests();
        }

        return 0;
    }

    public long getReceivedSipResponsesLong() {
        if (networkManager instanceof OLDNetworkManager) {
            return ((OLDNetworkManager) networkManager).getEasReceivedSipResponses();
        }

        return 0;
    }

    public long getSentSipRequestsLong() {
        if (networkManager instanceof OLDNetworkManager) {
            return ((OLDNetworkManager) networkManager).getEasSentSipRequests();
        }

        return 0;
    }

    public long getSentSipResponsesLong() {
        if (networkManager instanceof OLDNetworkManager) {
            return ((OLDNetworkManager) networkManager).getEasSentSipResponses();
        }

        return 0;
    }

    public CountStatistic getInvalidSipMessages() {
        invalidSipMessages.setCount((networkManager == null) ? 0
                                                             : getInvalidSipMessagesLong());

        return (CountStatistic) invalidSipMessages.unmodifiableView();
    }

    public CountStatistic getReceivedSipRequests() {
        receivedSipRequests.setCount((networkManager == null) ? 0
                                                              : getReceivedSipRequestsLong());

        return (CountStatistic) receivedSipRequests.unmodifiableView();
    }

    public CountStatistic getReceivedSipResponses() {
        receivedSipResponses.setCount((networkManager == null) ? 0
                                                               : getReceivedSipResponsesLong());

        return (CountStatistic) receivedSipResponses.unmodifiableView();
    }

    public CountStatistic getSentSipRequests() {
        sentSipRequests.setCount((networkManager == null) ? 0
                                                          : getSentSipRequestsLong());

        return (CountStatistic) sentSipRequests.unmodifiableView();
    }

    public CountStatistic getSentSipResponses() {
        sentSipResponses.setCount((networkManager == null) ? 0
                                                           : getSentSipResponsesLong());

        return (CountStatistic) sentSipResponses.unmodifiableView();
    }

    public Statistic getStatistic(String name) {
        return baseStatsImpl.getStatistic(name);
    }

    public String[] getStatisticNames() {
        return baseStatsImpl.getStatisticNames();
    }

    public Statistic[] getStatistics() {
        return baseStatsImpl.getStatistics();
    }

    public Class getInterfaceClass() {
        return NetworkManagerStats.class;
    }
}
