/*
 * SessionManagerStatsImpl.java
 *
 * Created on 2007-okt-04, 16:18:20
 *
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.jvnet.glassfish.comms.admin.monitor;

import com.ericsson.ssa.container.OverloadManager;
import com.ericsson.ssa.container.OverloadProtectionManager;
import com.ericsson.ssa.sip.Layer;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;


/**
 *
 * @author erapdan
 */
public class OverloadProtectionManagerStatsImpl
    implements OverloadProtectionManagerStats, SipStats {
    private MutableCountStatistic overloadRejectedHttpResponses;
    private MutableCountStatistic overloadRejectedSipResponses;

    // not used by this StatsImpl...
    private OverloadProtectionManager overloadProtectionManager = null;
    private GenericStatsImpl baseStatsImpl;

    public OverloadProtectionManagerStatsImpl() {
        initializeStatistics();
        baseStatsImpl = new GenericStatsImpl(OverloadProtectionManagerStats.class,
                this);
    }

    public void setStatsProvider(Layer provider){
        this.overloadProtectionManager = (OverloadProtectionManager)provider;
    }

    private void initializeStatistics() {
        CountStatistic c;
        c = new CountStatisticImpl("OverloadRejectedHttpResponses");
        overloadRejectedHttpResponses = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("OverloadRejectedSipResponses");
        overloadRejectedSipResponses = new MutableCountStatisticImpl(c);
    }

    public CountStatistic getOverloadRejectedHttpResponses() {
        overloadRejectedHttpResponses.setCount((overloadProtectionManager == null)
            ? 0
            : OverloadManager.getInstance().getEasOverloadRejectedHttpResponses());

        return (CountStatistic) overloadRejectedHttpResponses.unmodifiableView();
    }

    public CountStatistic getOverloadRejectedSipResponses() {
        overloadRejectedSipResponses.setCount((overloadProtectionManager == null)
            ? 0
            : OverloadManager.getInstance().getEasOverloadRejectedSipResponses());

        return (CountStatistic) overloadRejectedSipResponses.unmodifiableView();
    }

    public Statistic getStatistic(String name) {
        return baseStatsImpl.getStatistic(name);
    }

    public String[] getStatisticNames() {
        return baseStatsImpl.getStatisticNames();
    }

    public Statistic[] getStatistics() {
        return baseStatsImpl.getStatistics();
    }

    public Class getInterfaceClass() {
        return OverloadProtectionManagerStats.class;
    }
}
