/*
 * SessionManagerStatsImpl.java
 *
 * Created on 2007-okt-04, 16:18:20
 *
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.jvnet.glassfish.comms.admin.monitor;

import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.SessionManager;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;


/**
 *
 * @author erapdan
 */
public class SessionManagerStatsImpl implements SessionManagerStats, SipStats {
    private MutableCountStatistic failedSipDialogs;
    private MutableCountStatistic concurrentSipDialogs;
    private MutableCountStatistic expiredSipDialogs;
    private MutableCountStatistic successfulSipDialogs;
    private MutableCountStatistic totalSipDialogCount;
    private MutableCountStatistic totalSipDialogLifeTime;
    private SessionManager sessionManager = null;
    private GenericStatsImpl baseStatsImpl;

    public SessionManagerStatsImpl() {
        initializeStatistics();
        baseStatsImpl = new GenericStatsImpl(SessionManagerStats.class, this);
    }

    public void setStatsProvider(Layer provider) {
        this.sessionManager = (SessionManager)provider;
    }

    private void initializeStatistics() {
        CountStatistic c;
        c = new CountStatisticImpl("FailedSipDialogs");
        failedSipDialogs = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("ConcurrentSipDialogs");
        concurrentSipDialogs = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("expiredSipDialogs");
        expiredSipDialogs = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("successfulSipDialogs");
        successfulSipDialogs = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("totalSipDialogCount");
        totalSipDialogCount = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("totalSipDialogLifeTime");
        totalSipDialogLifeTime = new MutableCountStatisticImpl(c);
    }

    public CountStatistic getFailedSipDialogs() {
        failedSipDialogs.setCount((sessionManager == null) ? 0
                                                           : sessionManager.getEasFailedSipDialogs());

        return (CountStatistic) failedSipDialogs.unmodifiableView();
    }

    public CountStatistic getExpiredSipDialogs() {
        expiredSipDialogs.setCount((sessionManager == null) ? 0
                                                            : sessionManager.getEasExpiredSipDialogs());

        return (CountStatistic) expiredSipDialogs.unmodifiableView();
    }

    public CountStatistic getSuccessfulSipDialogs() {
        successfulSipDialogs.setCount((sessionManager == null) ? 0
                                                               : sessionManager.getEasSuccessfulSipDialogs());

        return (CountStatistic) successfulSipDialogs.unmodifiableView();
    }

    public CountStatistic getTotalSipDialogCount() {
        totalSipDialogCount.setCount((sessionManager == null) ? 0
                                                              : sessionManager.getEasTotalSipDialogCount());

        return (CountStatistic) totalSipDialogCount.unmodifiableView();
    }

    public CountStatistic getTotalSipDialogLifeTime() {
        totalSipDialogLifeTime.setCount((sessionManager == null) ? 0
                                                                 : sessionManager.getEasTotalSipDialogLifeTime());

        return (CountStatistic) totalSipDialogLifeTime.unmodifiableView();
    }

    public CountStatistic getConcurrentSipDialogs() {
        concurrentSipDialogs.setCount((sessionManager == null) ? 0
                                                               : sessionManager.getEasConcurrentSipDialogs());

        return (CountStatistic) concurrentSipDialogs.unmodifiableView();
    }

    public Statistic getStatistic(String name) {
        return baseStatsImpl.getStatistic(name);
    }

    public String[] getStatisticNames() {
        return baseStatsImpl.getStatisticNames();
    }

    public Statistic[] getStatistics() {
        return baseStatsImpl.getStatistics();
    }

    public Class getInterfaceClass() {
        return SessionManagerStats.class;
    }
}
