/*
 * SessionManagerStatsImpl.java
 *
 * Created on 2007-okt-04, 16:18:20
 *
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.jvnet.glassfish.comms.admin.monitor;

import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.transaction.TransactionManager;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;


/**
 *
 * @author erapdan
 */
public class TransactionManagerStatsImpl implements TransactionManagerStats, SipStats {
    private MutableCountStatistic sipClientTransactions;
    private MutableCountStatistic sipServerTransactions;
    private MutableCountStatistic totalSipTransactionCount;
    private MutableCountStatistic totalSipTransactionTime;
    private TransactionManager transactionManager = null;
    private GenericStatsImpl baseStatsImpl;

    public TransactionManagerStatsImpl() {
        initializeStatistics();
        baseStatsImpl = new GenericStatsImpl(TransactionManagerStats.class, this);
    }

    public void setStatsProvider(Layer provider) {
        this.transactionManager = (TransactionManager)provider;
    }

    private void initializeStatistics() {
        CountStatistic c;
        c = new CountStatisticImpl("sipClientTransactions");
        sipClientTransactions = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("sipServerTransactions");
        sipServerTransactions = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("totalSipTransactionCount");
        totalSipTransactionCount = new MutableCountStatisticImpl(c);

        c = new CountStatisticImpl("totalSipTransactionTime");
        totalSipTransactionTime = new MutableCountStatisticImpl(c);
    }

    public CountStatistic getSipClientTransactions() {
        sipClientTransactions.setCount((transactionManager == null) ? 0
                                                                    : transactionManager.getEasSipClientTransactions());

        return (CountStatistic) sipClientTransactions.unmodifiableView();
    }

    public CountStatistic getSipServerTransactions() {
        sipServerTransactions.setCount((transactionManager == null) ? 0
                                                                    : transactionManager.getEasSipServerTransactions());

        return (CountStatistic) sipServerTransactions.unmodifiableView();
    }

    public CountStatistic getTotalSipTransactionCount() {
        totalSipTransactionCount.setCount((transactionManager == null) ? 0
                                                                       : transactionManager.getEasTotalSipTransactionCount());

        return (CountStatistic) totalSipTransactionCount.unmodifiableView();
    }

    public CountStatistic getTotalSipTransactionTime() {
        totalSipTransactionTime.setCount((transactionManager == null) ? 0
                                                                      : transactionManager.getEasTotalSipTransactionTime());

        return (CountStatistic) totalSipTransactionTime.unmodifiableView();
    }

    public Statistic getStatistic(String name) {
        return baseStatsImpl.getStatistic(name);
    }

    public String[] getStatisticNames() {
        return baseStatsImpl.getStatisticNames();
    }

    public Statistic[] getStatistics() {
        return baseStatsImpl.getStatistics();
    }

    public Class getInterfaceClass() {
        return TransactionManagerStats.class;
    }

}
