/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.admin.monitor.registry.spi.extensions;

import com.ericsson.ssa.sip.Layer;
import com.sun.enterprise.admin.common.constant.AdminConstants;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.StatsHolder;
import com.sun.enterprise.admin.monitor.registry.spi.DottedNameFactory;
import com.sun.enterprise.admin.monitor.registry.spi.MonitoringObjectNames;
import com.sun.enterprise.admin.monitor.registry.spi.MonitoringRegistrationHelper;
import com.sun.enterprise.admin.monitor.stats.*;
import com.sun.enterprise.admin.pluggable.MonitoringManager;

import org.jvnet.glassfish.comms.admin.monitor.NetworkManagerStats;
import org.jvnet.glassfish.comms.admin.monitor.NetworkManagerStatsImpl;
import org.jvnet.glassfish.comms.admin.monitor.OverloadProtectionManagerStats;
import org.jvnet.glassfish.comms.admin.monitor.OverloadProtectionManagerStatsImpl;
import org.jvnet.glassfish.comms.admin.monitor.SessionManagerStats;
import org.jvnet.glassfish.comms.admin.monitor.SessionManagerStatsImpl;
import org.jvnet.glassfish.comms.admin.monitor.TransactionManagerStats;
import org.jvnet.glassfish.comms.admin.monitor.TransactionManagerStatsImpl;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.management.j2ee.statistics.Stats;
import org.jvnet.glassfish.comms.admin.monitor.SipLevelListener;
import org.jvnet.glassfish.comms.admin.monitor.SipStats;


/**
 * Manager class responsible for registration/unregistration of all the
 *  SIP Stats. In addition, this class is responsible for handling the
 * monitoring level change events pertaining to SIP monitoring
 */
public class SipMonitoringManagerImpl implements MonitoringManager,
    MonitoringLevelListener {
    private static final Logger logger = Logger.getLogger(AdminConstants.kLoggerName);
    private static final SipMonitoringManagerImpl smm = new SipMonitoringManagerImpl();
    private static final String SIP_SERVICE = "sip-service";
    public static final String NETWORK_MANAGER = "network-manager";
    public static final String SESSION_MANAGER = "session-manager";
    public static final String TRANSACTION_MANAGER = "transaction-manager";
    public static final String OVERLOAD_PROTECTION_MANAGER = "overload-protection-manager";
    private static StatsHolder rsHolder = null;

    /** Creates a new instance of SipMonitoringManagerImpl */
    public SipMonitoringManagerImpl() {
    }

    public static SipMonitoringManagerImpl getInstance() {
        return smm;
    }

    private static StatsHolder getRootStatsHolder() {
        return rsHolder;
    }

    private final StatsHolder getSipStatsHolder() {
        return getRootStatsHolder().getChild(SIP_SERVICE);
    }

    /**
     * Method that handles the registration of all the
     * stats for various layers of SIP stats
     */
    public void registerAllStats(StatsHolder rootStatsHolder) {
        rsHolder = rootStatsHolder;
        initializeSipService();

        try {
            registerSipStats(SESSION_MANAGER, new SessionManagerStatsImpl());
            registerSipStats(NETWORK_MANAGER, new NetworkManagerStatsImpl());
            registerSipStats(TRANSACTION_MANAGER, new TransactionManagerStatsImpl());
            registerSipStats(OVERLOAD_PROTECTION_MANAGER, new OverloadProtectionManagerStatsImpl());
        } catch (MonitoringRegistrationException ex) {
            Logger.getLogger(SipMonitoringManagerImpl.class.getName())
                  .log(Level.SEVERE, null, ex);
        }
    }

    public void initializeSipService() {
        MonitoredObjectType sipNode = MonitoredObjectType.newMonitoredObjectType(SIP_SERVICE,
                true);
        final StatsHolder ssNode = rsHolder.addChild(SIP_SERVICE, sipNode);
        assert (ssNode != null) : "Initialization Error in SipServiceCreation";
        ssNode.setObjectName(MonitoringObjectNames.getMonitoredObjectName(
                sipNode.getTypeName()));
        ssNode.setDottedName(DottedNameFactory.getDottedName(
                sipNode.getTypeName()));
        ssNode.registerMBean();
    }

    public boolean isSipServiceInitialized() {
        StatsHolder sips = getRootStatsHolder().getChild(SIP_SERVICE);

        return sips != null;
    }

    
    
    public void registerSipStats(String nodeName, SipStats statsImpl)
        throws MonitoringRegistrationException {
            
        if (statsImpl == null) {
            throw new IllegalArgumentException("registerStats  - null stats provided");
        }
        
        final StatsHolder sips = getSipStatsHolder();
        MonitoredObjectType moType = MonitoredObjectType.newMonitoredObjectType(nodeName, false);
        final StatsHolder moNode = sips.addChild(nodeName, moType);
        assert (moNode != null) : "MRH:registerStats - Initialization failed for " + nodeName;
        moNode.setObjectName(MonitoringObjectNames.getMonitoredObjectName(
                moType.getTypeName()));
        moNode.setDottedName(DottedNameFactory.getDottedName(
                moType.getTypeName(), sips.getName()));      
        moNode.setStats(statsImpl);
        moNode.setStatsClass(statsImpl.getInterfaceClass());
        logger.info(nodeName + "stats is registered");
        moNode.registerMBean();
        logger.info("nodeinfo: name:" + moNode.getName() + " type " + moNode.getType().getTypeName() + " class " + moNode.getStatsClassName());

    }

    
    public void enableSipStats(String nodeName, Layer provider, MonitoringLevel level){
        final StatsHolder node = getSipStatsHolder().getChild(nodeName);
        ((SipStats)(node.getStats())).setStatsProvider(provider);
        MonitoringRegistrationHelper mrh = MonitoringRegistrationHelper.getInstance();
        SipLevelListener listener = new SipLevelListener(nodeName);
        mrh.registerMonitoringLevelListener(listener, node.getType());
        //listener.changeLevel(MonitoringLevel.OFF, level, node.getType());        
        logger.info(nodeName + "stats is enabled for " + node.getType().getTypeName());
        logger.info("nodeinfo: name:" + node.getName() + " type " + node.getType().getTypeName() + " class " + node.getStatsClassName());
    }

    public void registerMBean(String nodeName, MonitoredObjectType type){
        final StatsHolder node = getSipStatsHolder().getChild(nodeName);
        if( type != node.getType())
            throw new RuntimeException("Bad object Type");
        if( node != null){
            logger.info("registered MBean for " + nodeName);
            node.registerMBean();
        }
    }

    public void unregisterMBean(String Node, MonitoredObjectType type){
        final StatsHolder node = getSipStatsHolder().getChild(Node);
        if( type != node.getType())
            throw new RuntimeException("Bad object Type");
        if( node != null){
            node.unregisterMBean();
        }
    }

    
 
    // Methods to handle the  monitoringlevel changes
    public void changeLevel(MonitoringLevel from, MonitoringLevel to,
        MonitoredObjectType type) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to,
        Stats handback) {
    }

    public void setLevel(MonitoringLevel level) {
    }


    
}
