/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.pluggable.extensions.sip;

import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.pluggable.AdminExtensionFeature;

import org.jvnet.glassfish.comms.admin.event.extensions.sip.SipLinkEvent;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.SipLinkEventListener;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.SipLinkEventListenerImpl;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.SipListenerEvent;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.SipListenerEventListener;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.SipListenerEventListenerImpl;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.SipProtocolEvent;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.SipProtocolEventListener;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.SipProtocolEventListenerImpl;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.SipServiceEvent;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.SipServiceEventListener;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.SipServiceEventListenerImpl;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.SipTimersEvent;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.SipTimersEventListener;
import org.jvnet.glassfish.comms.admin.event.extensions.sip.SipTimersEventListenerImpl;

import java.net.URL;

import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * Implement the Extended Admin feature for sip related tasks.
 *
 * @author: Vijaya Gadamsetty
 */
public class SipAdminExtensionFeatureImpl implements AdminExtensionFeature {
    private static final String SIP_ADMIN_DESCRIPTORS_FILENAME = "/sip-admin-mbeans-descriptors.xml";
    private static final String SIP_RUNTIME_DESCRIPTORS_FILENAME = "/sip-runtime-mbeans-descriptors.xml";
    private Logger adminLogger;
    private URL sipAdminMBeanRegistryURL = null;
    private URL sipRuntimeMBeanRegistryURL = null;

    public SipAdminExtensionFeatureImpl() {
        String loggerName = System.getProperty("com.sun.aas.admin.logger.name");

        if (loggerName != null) {
            adminLogger = Logger.getLogger(loggerName);
        } else {
            adminLogger = Logger.getAnonymousLogger();
        }
    }

    /*
     * Return the sip admin mbean descriptors xml file location.
     */
    public URL getAdminMBeanRegistryURL() {
        try {
            sipAdminMBeanRegistryURL = SipAdminExtensionFeatureImpl.class.getResource(SIP_ADMIN_DESCRIPTORS_FILENAME);
        } catch (Throwable t) {
            adminLogger.log(Level.WARNING,
                "core.adminconfig_adminregistry_not_found",
                SIP_ADMIN_DESCRIPTORS_FILENAME);
        }

        return sipAdminMBeanRegistryURL;
    }

    /*
     * Return the sip runtime mbean descriptors xml file location.
     */
    public URL getRuntimeMBeanRegistryURL() {
        try {
            sipRuntimeMBeanRegistryURL = SipAdminExtensionFeatureImpl.class.getResource(SIP_RUNTIME_DESCRIPTORS_FILENAME);
        } catch (Throwable t) {
            adminLogger.log(Level.WARNING,
                "core.adminconfig_adminregistry_not_found",
                SIP_RUNTIME_DESCRIPTORS_FILENAME);
        }

        return sipRuntimeMBeanRegistryURL;
    }

    public void registerEventListeners() {
        AdminEventListenerRegistry.registerEventListener(SipServiceEvent.eventType,
            new SipServiceEventListenerImpl(), SipServiceEventListener.class);
        AdminEventListenerRegistry.registerEventListener(SipListenerEvent.eventType,
            new SipListenerEventListenerImpl(), SipListenerEventListener.class);
        AdminEventListenerRegistry.registerEventListener(SipProtocolEvent.eventType,
            new SipProtocolEventListenerImpl(), SipProtocolEventListener.class);
        AdminEventListenerRegistry.registerEventListener(SipLinkEvent.eventType,
            new SipLinkEventListenerImpl(), SipLinkEventListener.class);
        AdminEventListenerRegistry.registerEventListener(SipTimersEvent.eventType,
            new SipTimersEventListenerImpl(), SipTimersEventListener.class);
    }
}
