/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.server.pluggable.extensions.sip;

import com.sun.enterprise.admin.pluggable.AdminExtensionFeature;
import com.sun.enterprise.admin.pluggable.MonitoringManager;
import com.sun.enterprise.ee.server.pluggable.EEPluggableFeatureImpl;
import com.sun.enterprise.pluggable.Utils;


/**
 * Properties that define implementation classes for pluggable features
 * used for the AS with sip container. An instance of this class
 * should be passed to getInstance() method of PluggableFeatureFactoryImpl
 * to create and have access to pluggable features.
 * This extends the features in EE version of AS.
 *
 * @author: Vijaya Gadamsetty
 */
public class SipEEPluggableFeatureImpl extends EEPluggableFeatureImpl {
    /**
     * Default constructor.
     */
    public SipEEPluggableFeatureImpl() {
        super();
        featureImplClasses.setProperty(Utils.getNQClassName(
                AdminExtensionFeature.class),
            "org.jvnet.glassfish.comms.admin.pluggable.extensions.sip.SipAdminExtensionFeatureImpl");
        featureImplClasses.setProperty(Utils.getNQClassName(
                MonitoringManager.class),
            "org.jvnet.glassfish.comms.admin.monitor.registry.spi.extensions.SipMonitoringManagerImpl");
    }
}
