/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core;


/**
 *
 * @author kshitiz
 */
public final class CLBConstants {
    /* boolean indicating that this is http component of converged load balancer */
    public static final int HTTP_CLB = 0;

    /* boolean indicating that this is sip component of converged load balancer */
    public static final int SIP_CLB = 1;

    /* prefix of http listener */
    public static final String HTTP_PROTOCOL = "http://";

    /* prefix of https listener */
    public static final String HTTPS_PROTOCOL = "https://";

    /* prefix of sip listener */
    public static final String SIP_PROTOCOL = "sip://";

    /* prefix of sips listener */
    public static final String SIPS_PROTOCOL = "sips://";

    /* default http port */
    public static final int DEFAULT_HTTP_PORT = 80;

    /* default https port */
    public static final int DEFAULT_HTTPS_PORT = 443;

    /* default sip port */
    public static final int DEFAULT_SIP_PORT = 5060;

    /* default sips port */
    public static final int DEFAULT_SIPS_PORT = 5061;

    /* BERoute key name */
    public static final String BEROUTE_KEY_NAME = "BERoute";

    /* BEkey key name */
    public static final String BEKEY_KEY_NAME = "BEKEY";

    /* proxy header for BERoute key*/
    public static final String PROXY_HEADER_BEROUTE_KEY = "proxy-beroute";

    /* proxy header for BEkey key*/
    public static final String PROXY_HEADER_BEKEY_KEY = "proxy-bekey";

    /* module name of the converged load-balancer */
    public static final String MODULE_NAME = "CLB";

    /* cookie header in http request */
    public static final String COOKIE_HEADER = "Cookie";

    /* default context root */
    public static final String DEFAULT_CONTEXT_ROOT = "/";

    /** Creates a new instance of CLBConstants */
    public CLBConstants() {
    }
}
