/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core;


/**
 *
 * @author kshitiz
 */
public abstract class ControllerInitializer {
    protected Controller controller;

    /* Creates a new instance of ControllerInitializer */
    public ControllerInitializer() {
        controller = null;
    }

    /**
     * This method is called by AdminService to create an instance of Controller
     *
     * @return a new controller instance
     */
    public Controller createController() {
        Controller newController = Controller.createInstance();

        return newController;
    }

    /**
     * This method is called by AdminService a new controller. On this new controller, admin
     * has already created cluster, instance and request group. A reconfig is performed and then
     * new controller is initialized. The current controller is replaced by new controller. And clean
     * up is performed on old controller
     *
     * @param newController the new controller instance
     */
    public void setController(Controller newController)
        throws CLBRuntimeException {
        if (controller != null) {
            newController.reconfig(controller);
        }

        newController.initialize();

        Controller oldController = controller;
        controller = newController;

        if (oldController != null) {
            oldController.cleanUp();
        }
    }
}
