/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core;

import com.sun.enterprise.admin.monitor.callflow.Listener;

import java.util.ArrayList;


/**
 * This class is DCR file event notifier. It listens for admin event related to DCR file and propagates to
 * the listeners waiting for this event.
 *
 * @author kshitiz
 */
public class DCRFileUpdateEventNotifier {
    private ArrayList<DCRFileUpdateEventListener> listeners;

    /** Creates a new instance of DCRFileUpdateEventNotifier */
    public DCRFileUpdateEventNotifier() {
        listeners = new ArrayList<DCRFileUpdateEventListener>();
    }

    /**
     * Add a dcr file update event listener
     *
     * @param listener dcr file update event listener
     */
    public void addDCRFileUpdateEventListener(
        DCRFileUpdateEventListener listener) {
        listeners.add(listener);
    }

    /**
     * This method is called by controller to register this class to admin event registry.
     */
    public void registerWithAdminEventListener() {
        if (listeners.size() > 0) {
            //TBD
            //register in admin event registry to listen for DCR file event
        }
    }

    /**
     * This method propagates dcr file update event to all its listeners.
     */
    public void propagateDCRFileUpdateEvent() {
        for (DCRFileUpdateEventListener listener : listeners) {
            listener.processDCRFileUpdateEvent();
        }
    }
}
