/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core;

import org.jvnet.glassfish.comms.clb.proxy.api.Endpoint;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;


/**
 *
 * @author kshitiz
 */
public class EndPoint implements org.jvnet.glassfish.comms.clb.proxy.api.Endpoint {
    /*host corresponding to this listener*/
    private String host;

    /*port corresponding to this listener*/
    private int port;

    /*protocol associated with this listener*/
    private String protocol;

    /*instance with which this listener is associated with*/
    private ServerInstance instance;

    /* flag indicating whether this endpoint is secure */
    private boolean secure;

    /* flag indicating whether this end point is local or remote */
    private boolean local;

    /* Inet address for this endpoint */
    private InetAddress inetAddress;

    /* Socket address for this endpoint */
    private SocketAddress socketAddress;
    
    /* a local end point */
    private static final EndPoint localEndPoint =  new EndPoint(true);

    /** Creates a new instance of EndPoint */
    public EndPoint(ServerInstance instance, String protocol, String hostName,
        int port, boolean local) throws CLBRuntimeException {
        this.protocol = protocol;
        this.host = hostName;
        this.port = port;
        this.instance = instance;
        this.local = local;

        if ((protocol == CLBConstants.HTTPS_PROTOCOL) ||
                (protocol == CLBConstants.SIPS_PROTOCOL)) {
            secure = true;
        } else {
            secure = false;
        }

        try {
            inetAddress = InetAddress.getByName(host);
        } catch (UnknownHostException ex) {
            String message = "Unable to lookup host " + hostName +
                " for the endpoint";
            throw new CLBRuntimeException(message, ex);
        }

        socketAddress = new InetSocketAddress(inetAddress, port);
    }

    private EndPoint(boolean local) {
        this.local = local;
    }

    public String getHost() {
        return host;
    }

    public int getPort() {
        return port;
    }

    public String getProtocol() {
        return protocol;
    }

    public ServerInstance getServerInstance() {
        return instance;
    }

    public boolean enableEndPoint() {
        throw new UnsupportedOperationException();
    }

    public boolean disableEndPoint() {
        throw new UnsupportedOperationException();
    }

    public SocketAddress getSocketAddress() {
        return socketAddress;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public InetAddress getIp() {
        return inetAddress;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return secure;
    }

    public boolean isLocal() {
        return local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public static Endpoint getLocalEndPoint() {
        return localEndPoint;
    }
}
