/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core;

import com.sun.grizzly.tcp.Response;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;


/**
 *
 * This is a request group to handle client requests.<br>
 * <br>
 * A request group is created per application. A request group maintains a complete
 * list of server instances/server cluster, which can service request asscociated with
 * this request group.<br>
 * <br>
 * The decision of selecting a instance to service the request is handled here.<br>
 *
 * @author kshitiz
 */
public interface RequestGroup {
    /**
     * add the cluster to this request group. The cluster added should have
     * ability to service request pertaining to this group.
     *
     * @param cluster the cluster
     */
    public void addCluster(ServerCluster cluster);

    /**
     * delete the cluster group from this request group.
     *
     * @param cluster the cluster
     */
    public void deleteCluster(ServerCluster cluster);

    /**
     * Initialize the router using all the clusters added to this request group.
     * The router will handle decision of selecting server instance to service the request
     *
     * @param lbpolicy policy to be used for load-balancing
     */
    public void initializeRouter(String lbpolicy) throws CLBRuntimeException;

    /**
     * Reinitialize the router. This should be called when cluster membership changes, i.e.,
     * cluster is added/deleted
     *
     */
    public void reinitializeRouter() throws CLBRuntimeException;

    /**
     * This method is called to service the request. The request/response objects are passed.
     * From the request objects, header and request url are extracted. Based on that routing
     * decision is made.<br>
     * <br>
     * This method will not actually service the request. It will decide which instance will
     * handle the request. This can be local or remote instance.<br>
     * <br>
     * The selection of instance will be delegated to the router associated with the instance.<br>
     *
     * @param req Request object
     * @param res Response object
     */
    public void serviceRequest(HttpRequest req, Response res);

    /**
     * This method is called before old controller is being destroyed. This can be used to perform
     * any clean up before controller is garbage collected.
     */
    public void cleanup();
}
