/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core;

import com.sun.grizzly.util.http.Parameters;
import java.util.logging.Level;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;

import java.util.Map;

import javax.servlet.http.Cookie;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 *
 * @author kshitiz
 */
public class StickyBERouteKeyExtractor {
    
    private static final LogUtil _logger = new LogUtil(StickyBERouteKeyExtractor.class);
    
    /**
     * Get the BERoute key from the request.  This key uniquely identifies the back-end instance.
     *
     * @param req the request
     *
     * @return the BERoute key if present, else return null
     */
    public static String getBERouteKey(HttpRequest request) {
        //check parameters for the key
        _logger.logMsg(Level.INFO, "Looking for parameter : " + CLBConstants.BEROUTE_KEY_NAME);
        Parameters parameters = request.getParameters();
        String value = parameters.getParameter(CLBConstants.BEROUTE_KEY_NAME);

        if (value != null) {
            _logger.logMsg(Level.INFO, "Got parameter : " + CLBConstants.BEROUTE_KEY_NAME 
                    + " having value : " + value);
            return value;
        }

        //search the cookies
        _logger.logMsg(Level.INFO, "Looking for cookie : " + CLBConstants.BEROUTE_KEY_NAME);
        String cookieString = request.getHeader(CLBConstants.COOKIE_HEADER);

        if ((cookieString == null) || (cookieString.length() == 0)) {
            _logger.logMsg(Level.INFO, "Request does not have any cookie");
            return null;
        }

        int index = cookieString.indexOf(CLBConstants.BEROUTE_KEY_NAME);

        if (index == -1) {
            _logger.logMsg(Level.INFO, "Request does not have cookie : " + CLBConstants.BEROUTE_KEY_NAME);
            return null;
        }

        int valueStartIndex = cookieString.indexOf("=", index + 1);

        if (valueStartIndex == -1) {
            _logger.logMsg(Level.INFO, "Request does not have cookie : " + CLBConstants.BEROUTE_KEY_NAME);
            return null;
        }

        String cookieValue = null;
        int valueEndIndex = cookieString.indexOf(";", valueStartIndex + 1);

        if (valueEndIndex == -1)
            valueEndIndex = cookieString.indexOf(",", valueStartIndex + 1);

        if (valueEndIndex == -1)
            cookieValue = cookieString.substring(valueStartIndex + 1);
        else
            cookieValue =  cookieString.substring(valueStartIndex + 1, valueEndIndex);
        
        _logger.logMsg(Level.INFO, "Request has cookie : " + CLBConstants.BEROUTE_KEY_NAME 
                + "with value : " + cookieValue);
        return cookieValue;
    }
}
